/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.custom.postgresql;

import com.healthmarketscience.sqlbuilder.BinaryCondition;

public class PgBinaryCondition
extends BinaryCondition {
    public PgBinaryCondition(PgOp binaryOp, Object leftValue, Object rightValue) {
        super((Object)binaryOp, leftValue, rightValue);
    }

    @Override
    protected boolean supportsEscape(Object binaryOp) {
        return binaryOp == PgOp.ILIKE || binaryOp == PgOp.NOT_ILIKE || binaryOp == PgOp.SIMILAR_TO || binaryOp == PgOp.NOT_SIMILAR_TO;
    }

    public static PgBinaryCondition iLike(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.ILIKE, value1, value2);
    }

    public static PgBinaryCondition notILike(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.NOT_ILIKE, value1, value2);
    }

    public static PgBinaryCondition similarTo(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.SIMILAR_TO, value1, value2);
    }

    public static PgBinaryCondition notSimilarTo(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.NOT_SIMILAR_TO, value1, value2);
    }

    public static PgBinaryCondition matchesRe(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.MATCHES_RE, value1, value2);
    }

    public static PgBinaryCondition notMatchesRe(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.NOT_MATCHES_RE, value1, value2);
    }

    public static PgBinaryCondition iMatchesRe(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.IMATCHES_RE, value1, value2);
    }

    public static PgBinaryCondition notIMatchesRe(Object value1, Object value2) {
        return new PgBinaryCondition(PgOp.NOT_IMATCHES_RE, value1, value2);
    }

    public static enum PgOp {
        ILIKE(" ILIKE "),
        NOT_ILIKE(" NOT ILIKE "),
        SIMILAR_TO(" SIMILAR TO "),
        NOT_SIMILAR_TO(" NOT SIMILAR TO "),
        MATCHES_RE(" ~ "),
        NOT_MATCHES_RE(" !~ "),
        IMATCHES_RE(" ~* "),
        NOT_IMATCHES_RE(" !~* ");

        private final String _opStr;

        private PgOp(String opStr) {
            this._opStr = opStr;
        }

        public String toString() {
            return this._opStr;
        }
    }
}

