/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.dto.enums;

import java.util.Arrays;
import org.qubership.atp.ei.ntt.dto.enums.DictionaryItem;

public enum AtpPriority implements DictionaryItem
{
    BLOCKER("Blocker"),
    CRITICAL("Critical"),
    MAJOR("Major"),
    NORMAL("Normal"),
    LOW("Low");

    private final String caption;

    private AtpPriority(String caption) {
        this.caption = caption;
    }

    public static AtpPriority getByCaption(String caption) {
        return Arrays.stream(AtpPriority.values()).filter(priority -> priority.getCaption().equals(caption)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such priority exists with this caption:" + caption));
    }

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public String getCaption() {
        return this.caption;
    }
}

