/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.dto.enums;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.ntt.dto.Directive;

public enum DirectiveEnum {
    USE(UUID.fromString("96c65818-d959-11e9-8a34-2a2ae2dbcce4"), "@Use()", "@Use(resource_system_name)"),
    WAIT_FOR_TA_RESPONSE_TIMEOUT(UUID.fromString("bdf310c0-d959-11e9-8a34-2a2ae2dbcce4"), "@WaitForTAResponseTimeout()", "@WaitForTAResponseTimeout(digital_seconds)"),
    SECTION(UUID.fromString("d98143b0-b7cf-42b0-804b-815e173724d9"), "@Section()", "@Section(section_name)"),
    PARALLEL_EXECUTION(UUID.fromString("9341b417-ae2e-42bd-8410-a08878d418f9"), "@ParallelExecution()", "@ParallelExecution(number_of_threads)"),
    CONDITION(UUID.fromString("da601fc8-ee84-4223-8589-7b17d2c50244"), "@Condition()", "@Condition(a>1, maxtime=2, attempts=3)"),
    INVERT_RESULT(UUID.fromString("a3693ce4-7ac9-415d-82d6-12d1c54d08dc"), "@InvertResult", "@InvertResult"),
    SKIP_ON_FAIL(UUID.fromString("3745c161-ebed-47cc-bcf8-f46abca26cc5"), "@skip_on_fail", "@skip_on_fail"),
    STOP_ON_FAIL(UUID.fromString("30d0db7d-6440-49d1-9d8b-6602c11051ed"), "@stop_on_fail", "@stop_on_fail"),
    WARN_IF_FAIL(UUID.fromString("493ac8e1-74f2-4821-aaa0-e6358ca120d4"), "@warn_if_fail", "@skip_on_fail"),
    HIDDEN(UUID.fromString("c3b7f1ea-8932-11ea-bc55-0242ac130003"), "@Hidden", "@hide_step");

    private Directive directive;
    private static final Map<UUID, Directive> byIdIndex;
    private static final Map<String, DirectiveEnum> byNameIndex;

    public static String getNameById(UUID id) {
        Preconditions.checkNotNull((Object)byIdIndex.get(id), (String)"Directive with ID %id does not exist", (Object)id);
        return byIdIndex.get(id).getName();
    }

    public static DirectiveEnum findByKey(String name) {
        Preconditions.checkNotNull((Object)((Object)byNameIndex.get(name)), (String)"Directive with ID %name does not exist", (Object)name);
        return byNameIndex.get(name);
    }

    private DirectiveEnum(UUID id, String name, String description) {
        this.directive = new Directive(id, name, description);
    }

    public Directive getDirective() {
        return this.directive;
    }

    public static List<Directive> getAll() {
        ArrayList<Directive> listDir = new ArrayList<Directive>();
        for (DirectiveEnum directiveEnum : DirectiveEnum.values()) {
            listDir.add(directiveEnum.getDirective());
        }
        return listDir;
    }

    public String getName() {
        return this.directive.getName();
    }

    public UUID getId() {
        return this.directive.getId();
    }

    static {
        byIdIndex = Maps.newHashMapWithExpectedSize((int)DirectiveEnum.values().length);
        byNameIndex = Maps.newHashMapWithExpectedSize((int)DirectiveEnum.values().length);
        for (DirectiveEnum dir : DirectiveEnum.values()) {
            byIdIndex.put(dir.directive.getId(), dir.directive);
            byNameIndex.put(dir.directive.getName(), dir);
        }
    }
}

