/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ei.ntt.model.Scope;
import org.qubership.atp.ei.ntt.model.ScopeItem;
import org.qubership.atp.ei.ntt.model.enums.ScopeSectionType;
import org.qubership.atp.ei.ntt.model.impl.AbstractTreeNode;

public class ScopeModel
extends AbstractTreeNode
implements Scope {
    @Override
    public List<ScopeItem> getScopeItems() {
        return super.getChildren();
    }

    private List<ScopeItem> getScopeItems(ScopeSectionType type, List<ScopeItem> sourceScopeItemList) {
        ArrayList<ScopeItem> filteredScopeItems = new ArrayList<ScopeItem>();
        for (ScopeItem scopeItem : sourceScopeItemList) {
            if (scopeItem.getStage() != type) continue;
            filteredScopeItems.add(scopeItem);
        }
        return filteredScopeItems;
    }

    @Override
    public List<ScopeItem> getScopeItems(ScopeSectionType type) {
        return this.getScopeItems(type, this.getScopeItems());
    }

    @Override
    public void setScopeItems(List<ScopeItem> scopeItems) {
        super.setChildren(scopeItems);
    }

    private List<ScopeItem> resetNumbering(List<ScopeItem> scopeItems) {
        if (scopeItems == null) {
            return null;
        }
        ArrayList<ScopeItem> scopePrerequisites = new ArrayList<ScopeItem>();
        ArrayList<ScopeItem> scopeActions = new ArrayList<ScopeItem>();
        ArrayList<ScopeItem> scopeValidation = new ArrayList<ScopeItem>();
        this.separateScopeItemsByScopeSection(scopeItems, scopePrerequisites, scopeActions, scopeValidation);
        List<ScopeItem> renumberedScopeItems = this.resetNumbers(scopePrerequisites, scopeActions, scopeValidation);
        return renumberedScopeItems;
    }

    private List<ScopeItem> resetNumbers(List<ScopeItem> prerequisites, List<ScopeItem> actions, List<ScopeItem> validation) {
        if (prerequisites == null || actions == null || validation == null) {
            return null;
        }
        int lastNumber = 0;
        lastNumber = this.renumberItemsFromIndex(prerequisites, lastNumber);
        lastNumber = this.renumberItemsFromIndex(actions, lastNumber);
        this.renumberItemsFromIndex(validation, lastNumber);
        ArrayList<ScopeItem> allRenumberedScopeItems = new ArrayList<ScopeItem>();
        allRenumberedScopeItems.addAll(prerequisites);
        allRenumberedScopeItems.addAll(actions);
        allRenumberedScopeItems.addAll(validation);
        return allRenumberedScopeItems;
    }

    private int renumberItemsFromIndex(List<ScopeItem> scopeItems, Integer lastIndex) {
        for (int index = 0; index < scopeItems.size(); ++index) {
            lastIndex = lastIndex + 1;
            scopeItems.get(index).setNumber(lastIndex);
        }
        return lastIndex;
    }

    private void separateScopeItemsByScopeSection(List<ScopeItem> allScopeItems, List<ScopeItem> prerequisites, List<ScopeItem> actions, List<ScopeItem> validation) {
        if (allScopeItems == null || prerequisites == null || actions == null || validation == null) {
            return;
        }
        prerequisites.clear();
        actions.clear();
        validation.clear();
        block5: for (ScopeItem scopeItem : allScopeItems) {
            switch (scopeItem.getStage()) {
                case PREREQUISITES: {
                    prerequisites.add(scopeItem);
                    continue block5;
                }
                case ACTIONS: {
                    actions.add(scopeItem);
                    continue block5;
                }
                case VALIDATION: {
                    validation.add(scopeItem);
                    continue block5;
                }
            }
        }
    }

    @Override
    public void addScopeItems(List<ScopeItem> scopeItems) {
        ArrayList<ScopeItem> toDelete = new ArrayList<ScopeItem>();
        for (ScopeItem item : scopeItems) {
            if (!this.getScopeItems().contains(item)) continue;
            toDelete.add(item);
        }
        scopeItems.removeAll(toDelete);
        super.getChildren().addAll(scopeItems);
        this.calcScopeItemsList();
    }

    @Override
    public void calcScopeItemsList() {
        this.setScopeItems(this.resetNumbering(this.getScopeItems()));
        int size = this.getScopeItems().size();
        for (int i = 0; i < size; ++i) {
            ScopeItem item = this.getScopeItems().get(i);
            String itemName = item.getName();
            String newName = String.format("%d_%s", item.getNumber(), itemName.substring(itemName.indexOf(95) + 1));
            item.setName(newName);
        }
    }

    @Override
    public ScopeItem getScopeItemByName(String name) {
        for (ScopeItem scopeItem : this.getScopeItems()) {
            if (!scopeItem.getName().equals(name)) continue;
            return scopeItem;
        }
        return null;
    }

    public void addItemToScope(ScopeItem newItem) {
        if (newItem == null) {
            return;
        }
        ArrayList<ScopeItem> currentScopeItems = new ArrayList<ScopeItem>(this.getScopeItems());
        ArrayList<ScopeItem> tempScope = new ArrayList<ScopeItem>(currentScopeItems);
        String newItemName = newItem.getName().replaceAll("\\d*_", "");
        for (int i = 0; i < tempScope.size(); ++i) {
            String itemName = ((ScopeItem)tempScope.get(i)).getName().replaceAll("\\d*_", "");
            if (!itemName.equals(newItemName) || !((ScopeItem)tempScope.get(i)).getProject().equals(newItem.getProject()) || !((ScopeItem)tempScope.get(i)).getStage().equals((Object)newItem.getStage())) continue;
            currentScopeItems.remove(i);
            break;
        }
        currentScopeItems.add(0, newItem);
        super.setChildren(currentScopeItems);
    }
}

