/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.ei.ntt.settings.ReflectionUtils;
import org.qubership.atp.ei.ntt.settings.model.dal.SettingsResource;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentItemLinkDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentItemLinksSectionDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentListDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.EnvironmentListsSectionDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServerDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServerTypesDal;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServersSettingsDal;
import org.qubership.atp.ei.ntt.settings.model.dal.support.DaoFactory;
import org.qubership.atp.ei.ntt.settings.model.environment.EnvironmentStorage;

public final class Settings {
    private static final DaoFactory factory = DaoFactory.getInstance();
    private static final SettingsResource settingsDAO;
    private static final Map<Class<?>, Object> wrapper;

    public static <T> T get(Class<T> clazz) {
        if (wrapper.containsKey(clazz)) {
            return (T)wrapper.get(clazz);
        }
        boolean isClassMatch = clazz != null && DaoFactory.ElementDal.class.isAssignableFrom(clazz);
        T object = isClassMatch ? factory.get(settingsDAO, clazz) : ReflectionUtils.getInstance(clazz);
        wrapper.put(clazz, object);
        return object;
    }

    public static void store() {
        factory.save(settingsDAO);
    }

    public static SettingsResource getSettingsResource() {
        return settingsDAO;
    }

    @Nonnull
    public static DaoFactory getDaoFactory() {
        return factory;
    }

    static {
        wrapper = new HashMap();
        settingsDAO = factory.loadResource(new SettingsResource());
    }

    public static class ServersSettings {
        private Map<String, ServerDal> serversMap = new HashMap<String, ServerDal>();

        @Nonnull
        public String getCurrentServerAlias() {
            ServersSettingsDal serverSettings = factory.get(settingsDAO, ServersSettingsDal.class);
            return serverSettings != null ? serverSettings.getCurrentServerAlias() : "";
        }

        public void setCurrentServerAlias(String currentServerAlias) {
            ServersSettingsDal serverSettings = factory.get(settingsDAO, ServersSettingsDal.class);
            if (serverSettings != null) {
                serverSettings.setCurrentServerAlias(currentServerAlias);
            }
        }

        @Nonnull
        public String getCurrentServerUrl() {
            ServersSettingsDal serverSettings = factory.get(settingsDAO, ServersSettingsDal.class);
            return serverSettings != null ? serverSettings.getCurrentServerUrl() : "";
        }

        private void loadServerMap() {
            ServersSettingsDal serverSettings = factory.get(settingsDAO, ServersSettingsDal.class);
            if (serverSettings == null || serverSettings.getServerList() == null) {
                return;
            }
            this.serversMap.clear();
            serverSettings.getServerList().forEach(server -> this.serversMap.put(server.getAlias(), (ServerDal)server));
        }

        private void storeServerMap() {
            ServersSettingsDal serverSettings = factory.get(settingsDAO, ServersSettingsDal.class);
            if (serverSettings == null || serverSettings.getServerList() == null) {
                return;
            }
            serverSettings.getServerList().clear();
            this.serversMap.entrySet().forEach(entry -> serverSettings.getServerList().add((ServerDal)entry.getValue()));
        }

        @Nonnull
        public Map<String, ServerDal> getServersMap() {
            if (this.serversMap.isEmpty()) {
                this.loadServerMap();
            }
            return this.serversMap;
        }

        @Nonnull
        public ServerDal[] getServers() {
            Collection<ServerDal> servers = this.getServersMap().values();
            return servers.toArray(new ServerDal[servers.size()]);
        }

        @Nullable
        public ServerDal getServer(int index) {
            return index > this.getServers().length - 1 || index < 0 ? null : this.getServers()[index];
        }

        public void addServer(@Nonnull ServerDal server) {
            this.getServersMap().put(server.getAlias(), server);
            this.storeServerMap();
        }

        public void updateServer(@Nonnull ServerDal oldServer, @Nonnull ServerDal newServer) {
            this.serversMap.remove(oldServer.getAlias());
            this.serversMap.put(newServer.getAlias(), newServer);
            this.storeServerMap();
        }

        public void deleteServer(int index) {
            ServerDal server = this.getServer(index);
            if (server == null) {
                return;
            }
            this.getServersMap().remove(server.getAlias());
            this.storeServerMap();
        }

        public void deleteServer(String alias) {
            ServerDal serverDal = this.getServersMap().get(alias);
            if (serverDal == null) {
                return;
            }
            this.getServersMap().remove(alias);
            this.storeServerMap();
        }

        @Nonnull
        public String[] getServerUrls() {
            ServerDal[] servers = this.getServers();
            String[] urls = new String[servers.length];
            int i = 0;
            for (ServerDal server : servers) {
                if (server == null) continue;
                urls[i] = server.getUrl();
                ++i;
            }
            return urls;
        }
    }

    public static class ServerTypesSettings {
        private List<String> serverTypes = Settings.access$100().get(Settings.access$000(), ServerTypesDal.class).getTypes();

        public List<String> getTypes() {
            return this.serverTypes;
        }

        public void add(@Nonnull String type) {
            if (!type.isEmpty() && !this.serverTypes.contains(type)) {
                this.serverTypes.add(type);
            }
        }

        public void delete(@Nonnull String type) {
            this.serverTypes.remove(type);
        }
    }

    public static class EnvironmentSettings
    implements EnvironmentStorage {
        private List<EnvironmentListDal> envListDals = Settings.access$100().get(Settings.access$000(), EnvironmentListsSectionDal.class).getEnvironmentLists();
        private List<EnvironmentItemLinkDal> envItemLinkDals = Settings.access$100().get(Settings.access$000(), EnvironmentItemLinksSectionDal.class).getEnvironmentItemLinks();

        @Override
        public List<EnvironmentListDal> getEnvironmentListDals() {
            return this.envListDals;
        }

        @Override
        public List<EnvironmentItemLinkDal> getEnvironmentItemLinkDals() {
            return this.envItemLinkDals;
        }

        @Override
        public void save() {
            this.saveEnvironmentLists();
        }

        @Override
        public void addEnvironmentItemLinkDal(EnvironmentItemLinkDal envItemLinkDal) {
            if (envItemLinkDal == null || !this.envItemLinkDals.contains(envItemLinkDal)) {
                return;
            }
            this.envItemLinkDals.add(envItemLinkDal);
        }

        @Override
        public void addEnvironmentItemLinkDals(List<EnvironmentItemLinkDal> itemLinkDals) {
            if (itemLinkDals == null) {
                return;
            }
            this.envItemLinkDals.addAll(itemLinkDals);
        }

        @Override
        public void removeEnvironmentItemLinkDal(EnvironmentItemLinkDal envItemLinkDal) {
            if (envItemLinkDal == null || !this.envItemLinkDals.contains(envItemLinkDal)) {
                return;
            }
            this.envItemLinkDals.remove(envItemLinkDal);
        }

        @Override
        public void removeAllEnvironmentItemLinkDalByName(String environmentName) {
            List<EnvironmentItemLinkDal> delItems = this.getLinksByEnvironmentListName(environmentName);
            this.envItemLinkDals.removeAll(delItems);
        }

        @Override
        public void updateEnvironmentItemLinkDalsOwner(String oldEnvListOwner, String newEnvListName) {
            if (newEnvListName == null || newEnvListName.isEmpty() || oldEnvListOwner == null || oldEnvListOwner.isEmpty()) {
                return;
            }
            List<EnvironmentItemLinkDal> foundedLinkDals = this.getLinksByEnvironmentListName(oldEnvListOwner);
            for (EnvironmentItemLinkDal item : foundedLinkDals) {
                item.setEnvironment(newEnvListName);
            }
        }

        @Override
        public List<EnvironmentItemLinkDal> getLinksByEnvironmentListName(String envListName) {
            ArrayList<EnvironmentItemLinkDal> foundedItems = new ArrayList<EnvironmentItemLinkDal>();
            for (EnvironmentItemLinkDal link : this.getEnvironmentItemLinkDals()) {
                if (!link.getEnvironment().equals(envListName)) continue;
                foundedItems.add(link);
            }
            return foundedItems;
        }

        @Override
        @Nullable
        public EnvironmentListDal getEnvironmentListDalByName(String envListName) {
            if (envListName == null || envListName.isEmpty()) {
                return null;
            }
            for (EnvironmentListDal list : this.getEnvironmentListDals()) {
                if (!list.getName().equals(envListName)) continue;
                return list;
            }
            return null;
        }

        @Override
        public void addEnvironmentListDal(@Nonnull EnvironmentListDal envListDal) {
            if (envListDal == null || this.envListDals.contains(envListDal)) {
                return;
            }
            this.envListDals.add(envListDal);
        }

        @Override
        public void removeEnvironmentListDal(@Nonnull EnvironmentListDal envListDal) {
            if (envListDal == null || !this.envListDals.contains(envListDal)) {
                return;
            }
            this.removeAllEnvironmentItemLinkDalByName(envListDal.getName());
            this.envListDals.remove(envListDal);
        }

        private void saveEnvironmentLists() {
            List<EnvironmentListDal> envListDals = factory.get(settingsDAO, EnvironmentListsSectionDal.class).getEnvironmentLists();
            envListDals.clear();
            envListDals.addAll(this.getEnvironmentListDals());
        }
    }
}

