/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model.dal.settings;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.ei.ntt.settings.model.Option;
import org.qubership.atp.ei.ntt.settings.model.Options;
import org.qubership.atp.ei.ntt.settings.model.dal.settings.ServerDal;
import org.qubership.atp.ei.ntt.settings.model.dal.support.DaoFactory;

public class ServersSettingsDal
extends DaoFactory.AbstractElementDal {
    @Option(key="serversSettings.currentServerAlias")
    private String currentServerAlias;
    @Options(key="serversSettings.server", parent="serversSettings", listClass=ServerDal.class)
    private List<ServerDal> serverList = new ArrayList<ServerDal>();

    public String getCurrentServerAlias() {
        return this.currentServerAlias != null ? this.currentServerAlias : (this.serverList.size() > 0 ? this.serverList.get(0).getAlias() : "");
    }

    @Nonnull
    public String getCurrentServerUrl() {
        for (ServerDal srv : this.serverList) {
            if (!srv.getAlias().equals(this.currentServerAlias)) continue;
            return Strings.nullToEmpty((String)srv.getUrl());
        }
        return Strings.nullToEmpty((String)this.serverList.get(0).getUrl());
    }

    public void setCurrentServerAlias(String currentServerAlias) {
        this.currentServerAlias = Strings.nullToEmpty((String)currentServerAlias);
    }

    @Nullable
    public List<ServerDal> getServerList() {
        return this.serverList;
    }

    @Nullable
    public ServerDal getServerByAlias(String alias) {
        for (ServerDal server : this.serverList) {
            if (!server.getAlias().equalsIgnoreCase(alias)) continue;
            return server;
        }
        return null;
    }
}

