/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.store.file.jdom;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathFactory;
import org.qubership.atp.ei.ntt.settings.model.Option;
import org.qubership.atp.ei.ntt.settings.model.Options;
import org.qubership.atp.ei.ntt.settings.store.option.AbstractOptionProcessor;
import org.qubership.atp.ei.ntt.settings.store.option.OptionProcessException;

public class JDomOptionProcessor
extends AbstractOptionProcessor<Element> {
    private static final List<Class<?>> primitives = Lists.newArrayList((Object[])new Class[]{String.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Long.TYPE, Long.class});
    private Logger log = Logger.getLogger(JDomOptionProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFieldValue(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    private Object getTypedValue(String value, Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return value;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return Double.valueOf(value);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Long.valueOf(value);
        }
        return value;
    }

    @Override
    public Object loadOption(Field field, Element source) throws OptionProcessException {
        String xpath = field.getAnnotation(Option.class).key();
        if (Strings.isNullOrEmpty((String)xpath)) {
            return this.getTypedValue(source.getText(), field.getType());
        }
        Element node = (Element)XPathFactory.instance().compile(xpath, Filters.element()).evaluateFirst((Object)source);
        if (node != null) {
            return this.getTypedValue(node.getText(), field.getType());
        }
        Attribute attribute = (Attribute)XPathFactory.instance().compile(xpath, Filters.attribute()).evaluateFirst((Object)source);
        if (attribute != null) {
            return this.getTypedValue(attribute.getValue(), field.getType());
        }
        return null;
    }

    @Override
    public Object loadOptions(Field field, Element source) throws OptionProcessException {
        String xpath = field.getAnnotation(Options.class).key();
        Type fieldGenericType = field.getGenericType();
        if (fieldGenericType instanceof ParameterizedType) {
            Class fieldClass = (Class)((ParameterizedType)fieldGenericType).getRawType();
            Type fieldTypeParameter = ((ParameterizedType)fieldGenericType).getActualTypeArguments()[0];
            if (Collection.class.isAssignableFrom(fieldClass)) {
                List possibleChilds = XPathFactory.instance().compile(xpath, Filters.element()).evaluate((Object)source);
                ArrayList values = Lists.newArrayListWithCapacity((int)(possibleChilds.size() + 5));
                Class collectionClass = fieldTypeParameter instanceof ParameterizedType ? (Class)((ParameterizedType)fieldTypeParameter).getRawType() : (Class)fieldTypeParameter;
                for (Element possibleChild : possibleChilds) {
                    if (primitives.contains(collectionClass)) {
                        values.add(this.getTypedValue(possibleChild.getText(), collectionClass));
                        continue;
                    }
                    try {
                        values.add(this.load(collectionClass.newInstance(), possibleChild));
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new OptionProcessException(e);
                    }
                }
                return values;
            }
            throw new OptionProcessException(String.format("Unsupported raw type: %s", fieldClass));
        }
        throw new OptionProcessException(String.format("Unknown field type: %s", fieldGenericType));
    }

    @Override
    public <Y> Y load(Y object, Element source) {
        Class<?> daoClass = object.getClass();
        while (!daoClass.getSuperclass().equals(Object.class)) {
            for (Field field : daoClass.getDeclaredFields()) {
                Object value;
                if (field.getAnnotation(Option.class) != null) {
                    try {
                        value = this.loadOption(field, source);
                        if (value == null) continue;
                        this.setFieldValue(object, field, value);
                    }
                    catch (OptionProcessException e) {
                        this.log.warn((Object)"Error loading option", (Throwable)e);
                    }
                    continue;
                }
                if (field.getAnnotation(Options.class) == null) continue;
                try {
                    value = this.loadOptions(field, source);
                    this.setFieldValue(object, field, value);
                }
                catch (OptionProcessException e) {
                    this.log.warn((Object)"Error loading option", (Throwable)e);
                }
            }
            daoClass = daoClass.getSuperclass();
        }
        return object;
    }

    @Override
    public void save(Object object, Element source) {
        int len = source.getAttributes().size();
        for (int i = 0; i < len; ++i) {
            source.removeAttribute((Attribute)source.getAttributes().get(0));
        }
        super.save(object, source);
    }

    private void setValue(Object element, Object value, boolean cdata) {
        if (element instanceof Element) {
            if (cdata) {
                ((Element)element).setContent((Content)new CDATA(Objects.toString(value, "")));
            } else {
                ((Element)element).setContent((Content)new Text(Objects.toString(value, "")));
            }
        } else if (element instanceof Attribute) {
            ((Attribute)element).setValue(Objects.toString(value, ""));
        }
    }

    private Object buildHierarchy(Element source, String xpath) {
        Iterable split = Splitter.onPattern((String)"(/|\\./)").omitEmptyStrings().split((CharSequence)xpath);
        Element element = source;
        Pattern pattern = Pattern.compile("\\[(\\d+)]");
        for (String name : split) {
            int index = 0;
            Matcher num = pattern.matcher(name);
            if (num.find()) {
                index = Integer.parseInt(num.group(1)) - 1;
            }
            if ((name = name.replaceAll("(\\[\\d+\\])", "")).startsWith("@")) {
                Attribute attribute = element.getAttribute(name = name.replace("@", ""));
                if (attribute == null) {
                    attribute = new Attribute(name, "");
                    element.setAttribute(attribute);
                }
                return attribute;
            }
            List children = element.getChildren(name);
            if (children.size() <= index) {
                Element child = new Element(name);
                element.addContent((Content)child);
            }
            element = (Element)element.getChildren(name).get(index);
        }
        return element;
    }

    @Override
    public void saveOption(Object object, Field field, Element source) throws OptionProcessException {
        boolean hasValues;
        Object value = this.getFieldValue(object, field);
        if (value == null) {
            return;
        }
        String xpath = field.getAnnotation(Option.class).key();
        if (Strings.isNullOrEmpty((String)xpath)) {
            this.setValue(source, value, true);
            return;
        }
        Element node = (Element)XPathFactory.instance().compile(xpath, Filters.element()).evaluateFirst((Object)source);
        boolean bl = hasValues = !value.equals("");
        if (node != null) {
            this.setValue(node, value, field.getAnnotation(Option.class).cdata() ? field.getAnnotation(Option.class).cdata() : hasValues);
        } else {
            Attribute attribute = (Attribute)XPathFactory.instance().compile(xpath, Filters.attribute()).evaluateFirst((Object)source);
            if (attribute != null) {
                this.setValue(attribute, value, hasValues);
            } else {
                this.setValue(this.buildHierarchy(source, xpath), value, false);
            }
        }
    }

    @Override
    protected void iterate(String xpath, Element source, List<?> toIterate, Class<?> collectionClass) {
        List existingChildren = XPathFactory.instance().compile(xpath, Filters.element()).evaluate((Object)source);
        for (int i = 0; i < toIterate.size(); ++i) {
            if (existingChildren.size() < i + 1) {
                String newXpath = String.format("%s[%s]", xpath, i + 1);
                this.buildHierarchy(source, newXpath);
                existingChildren = XPathFactory.instance().compile(xpath, Filters.element()).evaluate((Object)source);
            }
            if (primitives.contains(collectionClass)) {
                this.setValue(existingChildren.get(i), toIterate.get(i), false);
            } else {
                this.save(toIterate.get(i), (Element)existingChildren.get(i));
            }
            if (i >= existingChildren.size()) continue;
            for (int j = i; j < existingChildren.size(); ++j) {
                ((Element)existingChildren.get(j)).getParentElement().removeContent((Content)existingChildren.get(j));
            }
        }
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }
}

