/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.auth.springbootstarter.security.interceptors.MdcHttpRequestInterceptor;
import org.qubership.atp.common.logging.interceptor.RestTemplateLogInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"atp-auth.enable-m2m"}, matchIfMissing=true)
public class M2MTokenConfiguration {
    @Value(value="${keycloak.auth-server-url}")
    private String baseUrl;
    @Value(value="${keycloak.realm}")
    private String realm;
    @Value(value="${keycloak.resource}")
    private String clientId;
    @Value(value="${keycloak.credentials.secret}")
    private String clientSecret;
    @Value(value="${atp.logging.business.keys:userId,projectId,executionRequestId,testRunId,bvTestRunId,bvTestCaseId,environmentId,systemId,subscriberId,tsgSessionId,svpSessionId,dataSetId,dataSetListId,attributeId,itfLiteRequestId,reportType,itfSessionId,itfContextId,callChainId}")
    private String businessIds;

    @Bean(value={"resourceDetails"})
    public OAuth2ProtectedResourceDetails resourceDetails() {
        String issuer = this.baseUrl + "/realms/" + this.realm;
        String tokenUrl = issuer + "/protocol/openid-connect/token";
        ClientCredentialsResourceDetails resource = new ClientCredentialsResourceDetails();
        resource.setAccessTokenUri(tokenUrl);
        resource.setClientId(this.clientId);
        resource.setClientSecret(this.clientSecret);
        return resource;
    }

    @Bean(value={"m2mRestTemplate"})
    public RestTemplate m2mRestTemplate(OAuth2ProtectedResourceDetails resourceDetails, AccessTokenProvider accessTokenProvider, ClientHttpRequestFactory sslRequestFactory, RestTemplateLogInterceptor restTemplateLogInterceptor) {
        OAuth2RestTemplate restTemplate = new OAuth2RestTemplate(resourceDetails);
        restTemplate.setAccessTokenProvider(accessTokenProvider);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(sslRequestFactory));
        restTemplate.getInterceptors().add(restTemplateLogInterceptor);
        restTemplate.getInterceptors().add(new MdcHttpRequestInterceptor(this.getBusinessIdList(this.businessIds)));
        return restTemplate;
    }

    private List<String> getBusinessIdList(String businessIds) {
        return StringUtils.isNotBlank((CharSequence)businessIds) ? Arrays.stream(businessIds.split(",")).map(String::trim).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Bean
    public AccessTokenProvider accessTokenProvider(ClientHttpRequestFactory sslRequestFactory) {
        ClientCredentialsAccessTokenProvider tokenProvider = new ClientCredentialsAccessTokenProvider();
        tokenProvider.setRequestFactory(sslRequestFactory);
        return new AccessTokenProviderChain(Collections.singletonList(tokenProvider));
    }
}

