/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.config;

import brave.Span;
import brave.Tracer;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class Oauth2FeignClientInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(Oauth2FeignClientInterceptor.class);
    private final AccessTokenProvider accessTokenProvider;
    private final OAuth2ProtectedResourceDetails protectedResourceDetails;
    private final Tracer tracer;
    private final AccessTokenRequest accessTokenRequest;
    @Value(value="${atp-auth.refreshTimeBeforeExpirationInSec:300}")
    private Integer refreshTimeBeforeExpiration;

    public Oauth2FeignClientInterceptor(AccessTokenProvider accessTokenProvider, OAuth2ProtectedResourceDetails protectedResourceDetails, Tracer tracer) {
        this(accessTokenProvider, protectedResourceDetails, tracer, (AccessTokenRequest)new DefaultAccessTokenRequest());
    }

    public Oauth2FeignClientInterceptor(AccessTokenProvider accessTokenProvider, OAuth2ProtectedResourceDetails protectedResourceDetails, Tracer tracer, AccessTokenRequest accessTokenRequest) {
        this.accessTokenProvider = accessTokenProvider;
        this.protectedResourceDetails = protectedResourceDetails;
        this.tracer = tracer;
        this.accessTokenRequest = accessTokenRequest;
    }

    public void apply(RequestTemplate requestTemplate) {
        log.debug("start apply [requestTemplate.path={}]", (Object)requestTemplate.path());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Optional<KeycloakSecurityContext> contextOptional = Optional.ofNullable(authentication).map(Authentication::getPrincipal).filter(principal -> principal instanceof KeycloakPrincipal).map(principal -> (KeycloakPrincipal)principal).map(KeycloakPrincipal::getKeycloakSecurityContext);
        if (contextOptional.isPresent()) {
            log.debug("Keycloak context is present");
            KeycloakSecurityContext context = contextOptional.get();
            if (this.isAccessTokenExpired(context.getToken())) {
                log.debug("Access token is expired or almost expired. Token expiration {}. Set null to existing token in accessTokenRequest", (Object)context.getToken().getExpiration());
                this.accessTokenRequest.setExistingToken(null);
            } else {
                log.debug("user token found");
                this.setAuthorizationHeader(requestTemplate, context.getTokenString());
                return;
            }
        }
        Optional<Span> nextSpan = Optional.ofNullable(this.tracer).map(Tracer::nextSpan);
        try {
            OAuth2AccessToken existingToken = this.accessTokenRequest.getExistingToken();
            log.debug("Token expiration date {}", (Object)(Objects.nonNull(existingToken) ? existingToken.getExpiration() : null));
            if (Objects.nonNull(existingToken) && (existingToken.isExpired() || existingToken.getExpiresIn() < this.refreshTimeBeforeExpiration)) {
                log.debug("m2m token is expired or almost expired. expiration date {}", (Object)existingToken.getExpiration());
                this.accessTokenRequest.setExistingToken(null);
            }
            log.debug("Get m2m token");
            nextSpan.ifPresent(span -> {
                span.name("get m2m token");
                span.start();
            });
            OAuth2AccessToken accessToken = this.accessTokenProvider.obtainAccessToken(this.protectedResourceDetails, this.accessTokenRequest);
            log.debug("m2m token received with expiration date {}", (Object)accessToken.getExpiration());
            this.setAuthorizationHeader(requestTemplate, accessToken.getValue());
            this.accessTokenRequest.setExistingToken(accessToken);
        }
        catch (Exception e) {
            log.error("Failed to obtain m2m token", (Throwable)e);
            throw e;
        }
        finally {
            nextSpan.ifPresent(Span::finish);
        }
    }

    private boolean isAccessTokenExpired(AccessToken token) {
        if (Objects.isNull(token) || token.isExpired()) {
            return true;
        }
        int expiresIn = token.getExpiration() - Long.valueOf(System.currentTimeMillis() / 1000L).intValue();
        return expiresIn < this.refreshTimeBeforeExpiration;
    }

    public void setAuthorizationHeader(RequestTemplate requestTemplate, String token) {
        requestTemplate.header("Authorization", new String[]{String.format("%s %s", "Bearer", token)});
        Collection authorizationHeaderValues = (Collection)requestTemplate.headers().get("Authorization");
        boolean authorizationHeaderHasToken = authorizationHeaderValues.stream().anyMatch(value -> value.startsWith("Bearer".toLowerCase()));
        if (authorizationHeaderValues.size() > 1 && authorizationHeaderHasToken) {
            authorizationHeaderValues = authorizationHeaderValues.stream().filter(value -> !value.startsWith("Bearer".toLowerCase())).collect(Collectors.toList());
            requestTemplate.removeHeader("Authorization");
            requestTemplate.header("Authorization", (Iterable)authorizationHeaderValues);
        }
    }
}

