/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.services.client;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.ObjectPermissions;
import org.qubership.atp.auth.springbootstarter.entities.Operations;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.atp.auth.springbootstarter.entities.ServiceEntities;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="${feign.atp.users.name}", url="${feign.atp.users.url}")
public interface UsersFeignClient {
    @RequestMapping(method={RequestMethod.GET}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}"})
    public Project getUsersByProject(@PathVariable(value="projectId") UUID var1);

    @RequestMapping(method={RequestMethod.PATCH}, value={"${feign.atp.users.route}/api/v1/users/entities"})
    public void save(@RequestBody ServiceEntities var1);

    @RequestMapping(method={RequestMethod.PATCH}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}/services/{serviceName}/objects/{objectId}/permissions"})
    public ObjectPermissions saveObjectPermissions(@PathVariable UUID var1, @PathVariable String var2, @PathVariable String var3, @RequestBody Map<UUID, Operations> var4);

    @RequestMapping(method={RequestMethod.GET}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}/services/{serviceName}/objects/{objectId}/permissions"})
    public Map<String, Map<UUID, Operations>> getObjectPermissionsByObjectId(@PathVariable UUID var1, @PathVariable String var2, @PathVariable String var3);

    @RequestMapping(method={RequestMethod.GET}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}/services/{serviceName}/objects/permissions"})
    public Map<String, Map<UUID, Operations>> getObjectPermissionsByServiceName(@PathVariable UUID var1, @PathVariable String var2);

    @RequestMapping(method={RequestMethod.POST}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}/users/info"})
    public List<UserInfo> getUsersInfoByProjectId(@PathVariable UUID var1, @RequestBody List<UUID> var2);

    @RequestMapping(method={RequestMethod.DELETE}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}/services/{serviceName}/objects/{objectId}/permissions"})
    public void deleteObjectPermissions(@PathVariable UUID var1, @PathVariable String var2, @PathVariable String var3);

    @RequestMapping(method={RequestMethod.DELETE}, value={"${feign.atp.users.route}${atp-auth.project_info_endpoint}/{projectId}/services/{serviceName}/objects/permissions"})
    public void deleteObjectPermissionsBulk(@PathVariable UUID var1, @PathVariable String var2, @RequestBody List<String> var3);
}

