/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.monitoring.undertow.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.lang.NonNull;
import io.undertow.Undertow;
import io.undertow.server.ConnectorStatistics;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowMetrics;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;

public class UndertowConnectorMetrics
extends UndertowMetrics {
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_COUNT = ".connectors.requests.count";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_ERROR_COUNT = ".connectors.requests.error.count";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE = ".connectors.requests.active";
    private static final String METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE_MAX = ".connectors.requests.active.max";
    private static final String METRIC_NAME_CONNECTORS_BYTES_SENT = ".connectors.bytes.sent";
    private static final String METRIC_NAME_CONNECTORS_BYTES_RECEIVED = ".connectors.bytes.received";
    private static final String METRIC_NAME_CONNECTORS_PROCESSING_TIME = ".connectors.processing.time";
    private static final String METRIC_NAME_CONNECTORS_PROCESSING_TIME_MAX = ".connectors.processing.time.max";
    private static final String METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE = ".connectors.connections.active";
    private static final String METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE_MAX = ".connectors.connections.active.max";
    private static final String METRIC_TAG_PROTOCOL = "protocol";

    public UndertowConnectorMetrics(UndertowWebServer undertowWebServer) {
        super(undertowWebServer);
    }

    public UndertowConnectorMetrics(UndertowWebServer undertowWebServer, String namePrefix) {
        super(undertowWebServer, namePrefix);
    }

    public UndertowConnectorMetrics(UndertowWebServer undertowWebServer, String namePrefix, Iterable<Tag> tags) {
        super(undertowWebServer, namePrefix, tags);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry registry, Undertow undertow, String namePrefix, Iterable<Tag> tags) {
        List listenerInfoList = undertow.getListenerInfo();
        listenerInfoList.forEach(listenerInfo -> this.registerConnectorStatistics(registry, (Undertow.ListenerInfo)listenerInfo, namePrefix, tags));
    }

    private void registerConnectorStatistics(MeterRegistry registry, Undertow.ListenerInfo listenerInfo, String namePrefix, Iterable<Tag> tags) {
        String protocol = listenerInfo.getProtcol();
        ConnectorStatistics statistics = listenerInfo.getConnectorStatistics();
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_REQUESTS_COUNT), (Object)statistics, ConnectorStatistics::getRequestCount).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_REQUESTS_ERROR_COUNT), (Object)statistics, ConnectorStatistics::getErrorCount).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE), (Object)statistics, ConnectorStatistics::getActiveRequests).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("connections").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_REQUESTS_ACTIVE_MAX), (Object)statistics, ConnectorStatistics::getMaxActiveRequests).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("connections").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_BYTES_SENT), (Object)statistics, ConnectorStatistics::getBytesSent).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("bytes").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_BYTES_RECEIVED), (Object)statistics, ConnectorStatistics::getBytesReceived).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("bytes").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_PROCESSING_TIME), (Object)statistics, s -> TimeUnit.NANOSECONDS.toMillis(s.getProcessingTime())).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("ms").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_PROCESSING_TIME_MAX), (Object)statistics, s -> TimeUnit.NANOSECONDS.toMillis(s.getMaxProcessingTime())).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("ms").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE), (Object)statistics, ConnectorStatistics::getActiveConnections).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("connections").register(registry);
        Gauge.builder((String)(namePrefix + METRIC_NAME_CONNECTORS_CONNECTIONS_ACTIVE_MAX), (Object)statistics, ConnectorStatistics::getMaxActiveConnections).tags(tags).tag(METRIC_TAG_PROTOCOL, protocol).baseUnit("connections").register(registry);
    }
}

