/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.monitoring.undertow.metrics;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.MetricsHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class UndertowMetricsHandlerWrapper
implements HandlerWrapper {
    private final ServletContext servletContext;
    private static final Map<ServletContext, MetricsHandler> metricsHandlers = new ConcurrentHashMap<ServletContext, MetricsHandler>();

    public UndertowMetricsHandlerWrapper(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public HttpHandler wrap(HttpHandler handler) {
        MetricsHandler metricsHandler = new MetricsHandler(handler);
        metricsHandlers.put(this.servletContext, metricsHandler);
        return metricsHandler;
    }

    public static MetricsHandler getMetricsHandler(ServletContext servletContext) {
        return metricsHandlers.get(servletContext);
    }
}

