/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.monitoring.undertow.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.lang.NonNull;
import io.undertow.Undertow;
import java.util.ArrayList;
import java.util.Objects;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowMetrics;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.xnio.management.XnioWorkerMXBean;

public class UndertowXWorkerMetrics
extends UndertowMetrics {
    private static final String METRIC_NAME_X_WORK_WORKER_POOL_MAX_SIZE = ".xwork.worker.pool.max.size";
    private static final String METRIC_NAME_X_WORK_WORKER_POOL_SIZE = ".xwork.worker.pool.size";
    private static final String METRIC_NAME_X_WORK_WORKER_THREAD_BUSY_COUNT = ".xwork.worker.thread.busy.count";
    private static final String METRIC_NAME_X_WORK_IO_THREAD_COUNT = ".xwork.io.thread.count";
    private static final String METRIC_NAME_X_WORK_WORKER_QUEUE_SIZE = ".xwork.worker.queue.size";
    private static final String METRIC_CATEGORY = "name";

    public UndertowXWorkerMetrics(UndertowWebServer undertowWebServer) {
        super(undertowWebServer);
    }

    public UndertowXWorkerMetrics(UndertowWebServer undertowWebServer, String namePrefix) {
        super(undertowWebServer, namePrefix);
    }

    public UndertowXWorkerMetrics(UndertowWebServer undertowWebServer, String namePrefix, Iterable<Tag> tags) {
        super(undertowWebServer, namePrefix, tags);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry registry, Undertow undertow, String namePrefix, Iterable<Tag> tags) {
        XnioWorkerMXBean workerMXBean = undertow.getWorker().getMXBean();
        this.registerXWorker(registry, workerMXBean, namePrefix, tags);
    }

    private void registerXWorker(MeterRegistry registry, XnioWorkerMXBean workerMXBean, String namePrefix, Iterable<Tag> tags) {
        ArrayList<Tag> tagsList = new ArrayList<Tag>();
        if (Objects.nonNull(tags)) {
            tags.forEach(tagsList::add);
        }
        tagsList.add(Tag.of((String)METRIC_CATEGORY, (String)workerMXBean.getName()));
        this.bindGauge(registry, namePrefix + METRIC_NAME_X_WORK_WORKER_POOL_MAX_SIZE, "XWork max worker pool size", workerMXBean, XnioWorkerMXBean::getMaxWorkerPoolSize, tagsList);
        this.bindGauge(registry, namePrefix + METRIC_NAME_X_WORK_WORKER_POOL_SIZE, "XWork worker pool size", workerMXBean, XnioWorkerMXBean::getWorkerPoolSize, tagsList);
        this.bindGauge(registry, namePrefix + METRIC_NAME_X_WORK_WORKER_THREAD_BUSY_COUNT, "XWork busy worker thread count", workerMXBean, XnioWorkerMXBean::getBusyWorkerThreadCount, tagsList);
        this.bindGauge(registry, namePrefix + METRIC_NAME_X_WORK_IO_THREAD_COUNT, "XWork I/O thread count", workerMXBean, XnioWorkerMXBean::getIoThreadCount, tagsList);
        this.bindGauge(registry, namePrefix + METRIC_NAME_X_WORK_WORKER_QUEUE_SIZE, "XWork worker queue size", workerMXBean, XnioWorkerMXBean::getWorkerQueueSize, tagsList);
    }
}

