package org.qubership.atp.tdm.controllers.api.dto.actions;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.qubership.atp.tdm.controllers.api.dto.actions.ResponseTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ResponseMessageDto
 */

@JsonTypeName("ResponseMessage")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-23T14:16:30.887139084Z[Etc/UTC]")
public class ResponseMessageDto {

  @JsonProperty("content")
  private String content;

  @JsonProperty("contentObject")
  private Object contentObject;

  @JsonProperty("link")
  private String link;

  @JsonProperty("type")
  private ResponseTypeDto type;

  public ResponseMessageDto content(String content) {
    this.content = content;
    return this;
  }

  /**
   * Get content
   * @return content
  */
  
  @Schema(name = "content", required = false)
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public ResponseMessageDto contentObject(Object contentObject) {
    this.contentObject = contentObject;
    return this;
  }

  /**
   * Get contentObject
   * @return contentObject
  */
  
  @Schema(name = "contentObject", required = false)
  public Object getContentObject() {
    return contentObject;
  }

  public void setContentObject(Object contentObject) {
    this.contentObject = contentObject;
  }

  public ResponseMessageDto link(String link) {
    this.link = link;
    return this;
  }

  /**
   * Get link
   * @return link
  */
  
  @Schema(name = "link", required = false)
  public String getLink() {
    return link;
  }

  public void setLink(String link) {
    this.link = link;
  }

  public ResponseMessageDto type(ResponseTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public ResponseTypeDto getType() {
    return type;
  }

  public void setType(ResponseTypeDto type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResponseMessageDto responseMessage = (ResponseMessageDto) o;
    return Objects.equals(this.content, responseMessage.content) &&
        Objects.equals(this.contentObject, responseMessage.contentObject) &&
        Objects.equals(this.link, responseMessage.link) &&
        Objects.equals(this.type, responseMessage.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(content, contentObject, link, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResponseMessageDto {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    contentObject: ").append(toIndentedString(contentObject)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

