package org.qubership.atp.tdm.controllers.api.dto.statistics;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.tdm.controllers.api.dto.statistics.DateStatisticsItemDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DateStatisticsDto
 */

@JsonTypeName("DateStatistics")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-23T14:16:31.207300473Z[Etc/UTC]")
public class DateStatisticsDto {

  @JsonProperty("dates")
  @Valid
  private List<String> dates = null;

  @JsonProperty("items")
  @Valid
  private List<DateStatisticsItemDto> items = null;

  public DateStatisticsDto dates(List<String> dates) {
    this.dates = dates;
    return this;
  }

  public DateStatisticsDto addDatesItem(String datesItem) {
    if (this.dates == null) {
      this.dates = new ArrayList<>();
    }
    this.dates.add(datesItem);
    return this;
  }

  /**
   * Get dates
   * @return dates
  */
  
  @Schema(name = "dates", required = false)
  public List<String> getDates() {
    return dates;
  }

  public void setDates(List<String> dates) {
    this.dates = dates;
  }

  public DateStatisticsDto items(List<DateStatisticsItemDto> items) {
    this.items = items;
    return this;
  }

  public DateStatisticsDto addItemsItem(DateStatisticsItemDto itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
  */
  @Valid 
  @Schema(name = "items", required = false)
  public List<DateStatisticsItemDto> getItems() {
    return items;
  }

  public void setItems(List<DateStatisticsItemDto> items) {
    this.items = items;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DateStatisticsDto dateStatistics = (DateStatisticsDto) o;
    return Objects.equals(this.dates, dateStatistics.dates) &&
        Objects.equals(this.items, dateStatistics.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dates, items);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DateStatisticsDto {\n");
    sb.append("    dates: ").append(toIndentedString(dates)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

