package org.qubership.atp.tdm.controllers.api.dto.testdata;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataTableFilterDto;
import org.qubership.atp.tdm.controllers.api.dto.testdata.TestDataTableOrderDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestDataRequestDto
 */

@JsonTypeName("TestDataRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-23T14:16:31.449076310Z[Etc/UTC]")
public class TestDataRequestDto {

  @JsonProperty("dataTableOrder")
  private TestDataTableOrderDto dataTableOrder;

  @JsonProperty("filters")
  @Valid
  private List<TestDataTableFilterDto> filters = null;

  @JsonProperty("limit")
  private Integer limit;

  @JsonProperty("occupied")
  private Boolean occupied;

  @JsonProperty("offset")
  private Integer offset;

  @JsonProperty("tableName")
  private String tableName;

  public TestDataRequestDto dataTableOrder(TestDataTableOrderDto dataTableOrder) {
    this.dataTableOrder = dataTableOrder;
    return this;
  }

  /**
   * Get dataTableOrder
   * @return dataTableOrder
  */
  @Valid 
  @Schema(name = "dataTableOrder", required = false)
  public TestDataTableOrderDto getDataTableOrder() {
    return dataTableOrder;
  }

  public void setDataTableOrder(TestDataTableOrderDto dataTableOrder) {
    this.dataTableOrder = dataTableOrder;
  }

  public TestDataRequestDto filters(List<TestDataTableFilterDto> filters) {
    this.filters = filters;
    return this;
  }

  public TestDataRequestDto addFiltersItem(TestDataTableFilterDto filtersItem) {
    if (this.filters == null) {
      this.filters = new ArrayList<>();
    }
    this.filters.add(filtersItem);
    return this;
  }

  /**
   * Get filters
   * @return filters
  */
  @Valid 
  @Schema(name = "filters", required = false)
  public List<TestDataTableFilterDto> getFilters() {
    return filters;
  }

  public void setFilters(List<TestDataTableFilterDto> filters) {
    this.filters = filters;
  }

  public TestDataRequestDto limit(Integer limit) {
    this.limit = limit;
    return this;
  }

  /**
   * Get limit
   * @return limit
  */
  
  @Schema(name = "limit", required = false)
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public TestDataRequestDto occupied(Boolean occupied) {
    this.occupied = occupied;
    return this;
  }

  /**
   * Get occupied
   * @return occupied
  */
  
  @Schema(name = "occupied", required = false)
  public Boolean getOccupied() {
    return occupied;
  }

  public void setOccupied(Boolean occupied) {
    this.occupied = occupied;
  }

  public TestDataRequestDto offset(Integer offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Get offset
   * @return offset
  */
  
  @Schema(name = "offset", required = false)
  public Integer getOffset() {
    return offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  public TestDataRequestDto tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

  /**
   * Get tableName
   * @return tableName
  */
  
  @Schema(name = "tableName", required = false)
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestDataRequestDto testDataRequest = (TestDataRequestDto) o;
    return Objects.equals(this.dataTableOrder, testDataRequest.dataTableOrder) &&
        Objects.equals(this.filters, testDataRequest.filters) &&
        Objects.equals(this.limit, testDataRequest.limit) &&
        Objects.equals(this.occupied, testDataRequest.occupied) &&
        Objects.equals(this.offset, testDataRequest.offset) &&
        Objects.equals(this.tableName, testDataRequest.tableName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataTableOrder, filters, limit, occupied, offset, tableName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestDataRequestDto {\n");
    sb.append("    dataTableOrder: ").append(toIndentedString(dataTableOrder)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    occupied: ").append(toIndentedString(occupied)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

