/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.tdm.model.table.conditions.factories;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.conditions.type.TestDataTypeConditions;

public class TestDataTypeConditionFactory {

    /**
     * Gets test data type binary condition.
     */
    public static BinaryCondition getCondition(TestDataType testDataType) {
        switch (testDataType) {
            case AVAILABLE:
                return TestDataTypeConditions.getAvailableBinaryCondition();
            case OCCUPIED:
                return TestDataTypeConditions.getOccupiedBinaryCondition();
            default:
                throw new IllegalArgumentException("Unknown test data type condition: " + testDataType);
        }
    }
}
