/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.integration.environment;

import java.util.Optional;
import org.junit.rules.ExternalResource;
import org.qubership.atp.tdm.integration.containers.ForEachPostgresqlContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationPostgresEnvironment
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(IntegrationPostgresEnvironment.class);
    private static IntegrationPostgresEnvironment instance;
    private String postgresJdbcUrl = "jdbc:postgresql://localhost:5432/atp2_tdm";
    private ForEachPostgresqlContainer postgresContainer;

    private IntegrationPostgresEnvironment() {
        Optional<String> startEnvironment = Optional.ofNullable(System.getProperty("LOCAL_DOCKER_START"));
        if (startEnvironment.isPresent() && Boolean.parseBoolean(startEnvironment.get())) {
            this.postgresContainer = ForEachPostgresqlContainer.getInstance();
        } else {
            Optional<String> urlDB = Optional.ofNullable(System.getProperty("JDBC_URL"));
            if (urlDB.isPresent()) {
                this.postgresJdbcUrl = System.getProperty("JDBC_URL");
            }
            log.info("Postgres JDBC URL {}", (Object)this.postgresJdbcUrl);
        }
    }

    public static IntegrationPostgresEnvironment getInstance() {
        if (instance == null) {
            instance = new IntegrationPostgresEnvironment();
        }
        return instance;
    }

    protected void before() {
        if (this.postgresContainer != null) {
            this.postgresContainer.start();
            this.postgresJdbcUrl = this.postgresContainer.getPostgresIp();
        } else {
            log.info("Don't started Postgres Server container. Postgres JDBC URL {}", (Object)this.postgresJdbcUrl);
        }
    }

    protected void after() {
        if (this.postgresContainer != null) {
            this.postgresContainer.stop();
        }
    }

    public String getPostgresJdbcUrl() {
        return this.postgresJdbcUrl;
    }
}

