/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl;

import java.sql.Connection;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.env.configurator.exceptions.internal.TdmEnvDbConnectionException;
import org.qubership.atp.tdm.env.configurator.model.Server;
import org.qubership.atp.tdm.exceptions.db.TdmDbConnectionException;
import org.qubership.atp.tdm.exceptions.db.TdmDbDriverException;
import org.qubership.atp.tdm.repo.impl.SqlRepositoryImpl;
import org.qubership.atp.tdm.repo.impl.loader.TestDataSqlLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class TestDataSqlLoaderTest
extends AbstractTestDataTest {
    @Autowired
    SqlRepositoryImpl sqlRepository;
    private String QUERY = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS as col1 JOIN INFORMATION_SCHEMA.COLUMNS as col2 ON col1.COLUMN_NAME=col2.COLUMN_NAME JOIN INFORMATION_SCHEMA.COLUMNS as col3 ON col2.COLUMN_NAME=col3.COLUMN_NAME";

    @Test
    public void queryTimeout_executeHeavyQuery_throwTimeoutException() throws Exception {
        Exception exception = (Exception)Assertions.assertThrows(TimeoutException.class, () -> {
            Server server = system.getServer("DB");
            try (Connection connection = this.sqlRepository.createConnection(server);){
                TestDataSqlLoader sqlLoader = new TestDataSqlLoader(connection, this.QUERY, Integer.valueOf(1));
                sqlLoader.process();
            }
        });
    }

    @Test
    public void sqlRepository_getServer_throwConnectionException() {
        Exception exception = (Exception)Assertions.assertThrows(TdmEnvDbConnectionException.class, () -> system.getServer("noName"));
    }

    @Test
    public void sqlRepository_createConnection_throwTdmDbDrierException() throws Exception {
        Exception exception = (Exception)Assertions.assertThrows(TdmDbDriverException.class, () -> {
            Server server = new Server(dbConnectionErrorDbType, "DB");
            this.sqlRepository.createConnection(server);
        });
    }

    @Test
    public void sqlRepository_createConnection_throwTdmDbConnectionException() throws Exception {
        Exception exception = (Exception)Assertions.assertThrows(TdmDbConnectionException.class, () -> {
            Server server = new Server(dbConnectionErrorCredentials, "DB");
            this.sqlRepository.createConnection(server);
        });
    }
}

