/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.ColumnValues;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.utils.TestDataTableConvertor;

public class TestDataTableRepositoryTest
extends AbstractTestDataTest {
    @Test
    public void testDataTableRepository_getFullTestDataTest_extractedTableEqualToExpected() {
        String tableName = TestDataTableConvertor.generateTestDataTableName();
        TestDataTable expectedTable = this.createTestDataTable(tableName);
        TestDataTable actualTable = this.testDataTableRepository.getFullTestData(tableName);
        for (int rowNum = 0; rowNum < expectedTable.getData().size() - 1; ++rowNum) {
            Map expectedRow = (Map)expectedTable.getData().get(rowNum);
            Map actualRow = (Map)actualTable.getData().get(rowNum);
            for (String key : expectedRow.keySet()) {
                Object expectedValue = expectedRow.get(key);
                Object actualValue = actualRow.get(key);
                MatcherAssert.assertThat((String)"Values are not equal.", expectedValue, (Matcher)CoreMatchers.is(actualValue));
            }
        }
        this.deleteTestDataTableIfExists(tableName);
    }

    @Test
    public void testInsertRow_addNewColumn_newColumnExist() {
        String tableName = TestDataTableConvertor.generateTestDataTableName();
        this.createTestDataTable(tableName);
        TestDataTable testDataBeforeInsertRow = this.testDataService.getTestData(tableName);
        List columnsBeforeInsertRow = testDataBeforeInsertRow.getColumns();
        List rowBeforeInsert = columnsBeforeInsertRow.stream().map(t -> t.getIdentity().getColumnName()).collect(Collectors.toList());
        HashMap<String, Object> srt = new HashMap<String, Object>();
        srt.put("newColumn", null);
        ArrayList<HashMap<String, Object>> rows = new ArrayList<HashMap<String, Object>>();
        rows.add(srt);
        this.testDataTableRepository.insertRows(tableName, true, rows, false);
        TestDataTable testDataAfterInsertRow = this.testDataService.getTestData(tableName);
        List columnsAfterInsertRow = testDataAfterInsertRow.getColumns();
        List rowAfterInsert = columnsAfterInsertRow.stream().map(t -> t.getIdentity().getColumnName()).collect(Collectors.toList());
        rowAfterInsert.removeAll(rowBeforeInsert);
        Assertions.assertEquals(rowAfterInsert.get(0), (Object)"newColumn");
        this.deleteTestDataTableIfExists(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertRow_addEmptyArrayRow_returnException() {
        String tableName = TestDataTableConvertor.generateTestDataTableName();
        this.createTestDataTable(tableName);
        ArrayList rows = new ArrayList();
        try {
            this.testDataTableRepository.insertRows(tableName, true, rows, false);
        }
        catch (RuntimeException e) {
            String message = "There are no data to insert.";
            Assertions.assertEquals((Object)message, (Object)e.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
        }
    }

    @Test
    public void tableRepository_getColumnDistinctValues_success() {
        String tableName = TestDataTableConvertor.generateTestDataTableName();
        this.createTestDataTable(tableName);
        try {
            ColumnValues rowId = this.testDataTableRepository.getColumnDistinctValues(tableName, "ROW_ID", Boolean.valueOf(false));
            Assertions.assertEquals((int)rowId.getItems().size(), (int)6);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
        }
    }

    @Test
    public void tableRepository_updateLastUsage_success() {
        String tableTitle = "tdm_update_last_usage";
        String tableName = TestDataTableConvertor.generateTestDataTableName();
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        this.testDataTableRepository.updateLastUsage(tableName);
        String expectedLastUsage = this.catalogRepository.findByTableName(tableName).getLastUsage().toString();
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertTrue((boolean)expectedLastUsage.contains(new SimpleDateFormat("yyyy-MM-dd").format(new Date())));
    }
}

