/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.env.configurator.model.Connection;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.model.Project;
import org.qubership.atp.tdm.model.ProjectInformation;
import org.qubership.atp.tdm.model.mail.charts.ChartSeries;
import org.qubership.atp.tdm.model.statistics.AvailableDataStatisticsConfig;
import org.qubership.atp.tdm.model.statistics.ConsumedStatistics;
import org.qubership.atp.tdm.model.statistics.ConsumedStatisticsItem;
import org.qubership.atp.tdm.model.statistics.DateStatistics;
import org.qubership.atp.tdm.model.statistics.DateStatisticsItem;
import org.qubership.atp.tdm.model.statistics.GeneralStatisticsItem;
import org.qubership.atp.tdm.model.statistics.OccupiedDataByUsersStatistics;
import org.qubership.atp.tdm.model.statistics.OutdatedStatistics;
import org.qubership.atp.tdm.model.statistics.OutdatedStatisticsItem;
import org.qubership.atp.tdm.model.statistics.TestAvailableDataMonitoring;
import org.qubership.atp.tdm.model.statistics.TestDataTableMonitoring;
import org.qubership.atp.tdm.model.statistics.TestDataTableUsersMonitoring;
import org.qubership.atp.tdm.model.statistics.UserGeneralStatisticsItem;
import org.qubership.atp.tdm.model.statistics.UsersOccupyStatisticRequest;
import org.qubership.atp.tdm.model.statistics.UsersOccupyStatisticResponse;
import org.qubership.atp.tdm.model.statistics.available.AvailableDataByColumnStats;
import org.qubership.atp.tdm.model.statistics.available.TableAvailableDataStats;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportElement;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportEnvironment;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportObject;
import org.qubership.atp.tdm.model.statistics.report.UsersStatisticsReportElement;
import org.qubership.atp.tdm.model.statistics.report.UsersStatisticsReportObject;
import org.qubership.atp.tdm.model.table.TableColumnValues;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.TestAvailableDataMonitoringRepository;
import org.qubership.atp.tdm.repo.TestDataUsersMonitoringRepository;
import org.qubership.atp.tdm.utils.AvailableStatisticUtils;
import org.qubership.atp.tdm.utils.DataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.jdbc.Sql;

@Sql(value={"/scripts.sql"})
public class StatisticsServiceTest
extends AbstractTestDataTest {
    private static final List<String> COLUMN_NAMES = Arrays.asList("SIM", "Status", "Partner", "Partner category", "Partner ID", "Operator ID", "ENVIRONMENT", "Assignment");
    private static final UUID projectId = UUID.randomUUID();
    private static final String TABLE_TITLE = "Test Data";
    private static final String DEFAULT_ASSIGNMENT = "across all";
    private static final String TABLE_NAME_FIRST = "test_table_statistic_availability_first";
    private static final String TABLE_NAME_SECOND = "test_table_statistic_availability_second";
    private String cron = "0 0 9 ? * *";
    private static final UUID systemIdSecond = UUID.randomUUID();
    private static final UUID environmentIdSecond = UUID.randomUUID();
    private static final org.qubership.atp.tdm.env.configurator.model.System systemSecond = new org.qubership.atp.tdm.env.configurator.model.System(){
        {
            this.setName("Test System second");
            this.setId(systemIdSecond);
            ArrayList<Connection> connections = new ArrayList<Connection>();
            connections.add(dbConnection);
            connections.add(httpConnection);
            this.setConnections(connections);
        }
    };
    private static final LazySystem lazySystemSecond = new LazySystem(){
        {
            this.setName("Test System second");
            this.setId(systemIdSecond);
        }
    };
    private static final LazyEnvironment lazyEnvironmentSecond = new LazyEnvironment(){
        {
            this.setName("Test Environment second");
            this.setId(environmentIdSecond);
            this.setProjectId(projectId);
            this.setSystems(Collections.singletonList(systemSecond.getId().toString()));
        }
    };
    private static final List<LazyEnvironment> lazyEnvironments = Arrays.asList(lazyEnvironment, lazyEnvironmentSecond);
    private static final LazyProject lazyProject = new LazyProject(){
        {
            this.setName("Test Statistics Project");
            this.setId(projectId);
        }
    };
    private static final Project project = new Project(){
        {
            this.setName("Test Statistics Project");
            this.setId(projectId);
            this.setEnvironments(Arrays.asList(environment));
        }
    };
    private UsersOccupyStatisticRequest usersOccupyStatisticRequest;
    private GeneralStatisticsItem availableItemFirst;
    private GeneralStatisticsItem availableItemSecond;
    private ConsumedStatisticsItem consumedItemFirstDays;
    private ConsumedStatisticsItem consumedItemFirstWeeks;
    private ConsumedStatisticsItem consumedItemFirstMonths;
    private ConsumedStatisticsItem consumedItemSecond;
    private OutdatedStatisticsItem outdatedItemFirst;
    private OutdatedStatisticsItem outdatedItemFirstWeeks;
    private OutdatedStatisticsItem outdatedItemFirstMonths;
    private OutdatedStatisticsItem outdatedItemSecond;
    private DateStatisticsItem createdWhenItemFirst;
    @Value(value="${highcharts.template.path}")
    String highchartJsonPath;
    @Value(value="${highcharts.template}")
    String highchartJsonTemplate;
    @Autowired
    protected TestDataUsersMonitoringRepository testDataUsersMonitoringRepository;
    @Autowired
    private TestAvailableDataMonitoringRepository availableDataMonitoringRepository;

    public void setUp() {
        this.deleteTestDataTableIfExists(TABLE_NAME_FIRST);
        this.deleteTestDataTableIfExists(TABLE_NAME_SECOND);
        this.catalogRepository.deleteByTableName(TABLE_NAME_FIRST);
        this.catalogRepository.deleteByTableName(TABLE_NAME_SECOND);
        this.projectInformationService.saveProjectInformation(new ProjectInformation(projectId, "GMT+03:00", "d MMM yyyy", "hh:mm:ss a", 1L));
        Mockito.when((Object)this.environmentsService.getFullProject((UUID)ArgumentMatchers.any())).thenReturn((Object)project);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, TABLE_TITLE, TABLE_NAME_FIRST);
        this.createTestDataTable(TABLE_NAME_FIRST);
        TestDataTable tableFirst = this.testDataService.getTestData(TABLE_NAME_FIRST);
        List<UUID> rowIdsToOccupyFirst = this.extractRowIds(tableFirst.getData().subList(0, 1));
        this.testDataService.occupyTestData(TABLE_NAME_FIRST, "TestUser", rowIdsToOccupyFirst);
        this.availableItemFirst = new GeneralStatisticsItem(TABLE_TITLE, Long.valueOf(5L), Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(6L));
        this.availableItemFirst.setEnvironment(environment.getName());
        this.availableItemFirst.setSystem(system.getName());
        this.consumedItemFirstDays = new ConsumedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(0L);
            }
        });
        this.consumedItemFirstDays.setEnvironment(environment.getName());
        this.consumedItemFirstDays.setSystem(system.getName());
        this.consumedItemFirstWeeks = new ConsumedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        });
        this.consumedItemFirstWeeks.setEnvironment(environment.getName());
        this.consumedItemFirstWeeks.setSystem(system.getName());
        this.consumedItemFirstMonths = new ConsumedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        });
        this.consumedItemFirstMonths.setEnvironment(environment.getName());
        this.consumedItemFirstMonths.setSystem(system.getName());
        this.outdatedItemFirst = new OutdatedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(5L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
            }
        });
        this.outdatedItemFirst.setEnvironment(environment.getName());
        this.outdatedItemFirst.setSystem(system.getName());
        this.outdatedItemFirstWeeks = new OutdatedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(5L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        });
        this.outdatedItemFirstWeeks.setEnvironment(environment.getName());
        this.outdatedItemFirstWeeks.setSystem(system.getName());
        this.outdatedItemFirstMonths = new OutdatedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(5L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        });
        this.outdatedItemFirstMonths.setEnvironment(environment.getName());
        this.outdatedItemFirstMonths.setSystem(system.getName());
        this.createdWhenItemFirst = new DateStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(7L);
                this.add(0L);
            }
        });
        this.createdWhenItemFirst.setEnvironment(environment.getName());
        this.createdWhenItemFirst.setSystem(system.getName());
        this.createTestDataTableCatalog(projectId, systemIdSecond, environmentIdSecond, TABLE_TITLE, TABLE_NAME_SECOND);
        this.createTestDataTable(TABLE_NAME_SECOND);
        TestDataTable tableSecond = this.testDataService.getTestData(TABLE_NAME_SECOND);
        List<UUID> rowIdsToOccupySecond = this.extractRowIds(tableSecond.getData().subList(0, 2));
        this.testDataService.occupyTestData(TABLE_NAME_SECOND, "TestUser", rowIdsToOccupySecond);
        this.availableItemSecond = new GeneralStatisticsItem(TABLE_TITLE, Long.valueOf(4L), Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(6L));
        this.availableItemSecond.setEnvironment(lazyEnvironmentSecond.getName());
        this.availableItemSecond.setSystem(systemSecond.getName());
        this.consumedItemSecond = new ConsumedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(2L);
                this.add(0L);
            }
        });
        this.consumedItemSecond.setEnvironment(lazyEnvironmentSecond.getName());
        this.consumedItemSecond.setSystem(systemSecond.getName());
        this.outdatedItemSecond = new OutdatedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(4L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(2L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
            }
        });
        this.outdatedItemSecond.setEnvironment(lazyEnvironmentSecond.getName());
        this.outdatedItemSecond.setSystem(systemSecond.getName());
        DateStatisticsItem createdWhenItemSecond = new DateStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(2L);
                this.add(0L);
            }
        });
        createdWhenItemSecond.setEnvironment(lazyEnvironmentSecond.getName());
        createdWhenItemSecond.setSystem(systemSecond.getName());
        this.usersOccupyStatisticRequest = new UsersOccupyStatisticRequest(projectId, Long.valueOf(0L), Long.valueOf(10L), null, null, LocalDate.now().minusDays(1L).toString(), LocalDate.now().plusDays(1L).toString());
        Mockito.when((Object)this.environmentsService.getLazyProjectById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
        Mockito.when((Object)this.environmentsService.getLazyEnvironments((UUID)ArgumentMatchers.any())).thenReturn(lazyEnvironments);
        Mockito.when((Object)this.environmentsService.getLazySystemById(systemId)).thenReturn((Object)lazySystem);
        Mockito.when((Object)this.environmentsService.getLazySystemById(systemIdSecond)).thenReturn((Object)lazySystemSecond);
        Mockito.when((Object)this.environmentsService.getLazyEnvironment(environmentId)).thenReturn((Object)lazyEnvironment);
        Mockito.when((Object)this.environmentsService.getLazyEnvironment(environmentIdSecond)).thenReturn((Object)lazyEnvironmentSecond);
        Mockito.when((Object)this.environmentsService.getEnvNameById(environmentId)).thenReturn((Object)"Test Environment");
        Mockito.when((Object)this.environmentsService.getEnvNameById(environmentIdSecond)).thenReturn((Object)"Test Environment second");
    }

    protected void cleanUp() {
        this.deleteTestDataTable(TABLE_NAME_FIRST);
        this.deleteTestDataTable(TABLE_NAME_SECOND);
        this.catalogRepository.deleteByTableName(TABLE_NAME_FIRST);
        this.catalogRepository.deleteByTableName(TABLE_NAME_SECOND);
    }

    protected void mockEnvForStatistics() {
        Mockito.when((Object)this.environmentsService.getLazyEnvironment((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
        Mockito.when((Object)this.environmentsService.getLazySystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazySystem);
        Mockito.when((Object)this.environmentsService.getEnvNameById(environmentId)).thenReturn((Object)"Test Environment");
    }

    @Test
    public void statisticsService_checkAvailabilityOnEnvironment_returnsAvailabilityStatistics() {
        this.setUp();
        ArrayList<GeneralStatisticsItem> expectedStatistics = new ArrayList<GeneralStatisticsItem>();
        expectedStatistics.add(this.availableItemFirst);
        List actualStatistics = this.statisticsService.getTestDataAvailability(projectId, systemId);
        Assertions.assertEquals(expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void availableStatisticsUtils_buildConfiguration_bodyCorrect() throws IOException {
        ArrayList<ChartSeries> charts = new ArrayList<ChartSeries>();
        charts.add(new ChartSeries(true, Arrays.asList(1, 2, 3), "columnaName1", "#000FFF"));
        charts.add(new ChartSeries(true, Arrays.asList(4, 5, 6), "columnaName2", "#FFF000"));
        String act = AvailableStatisticUtils.buildHighChartConfigurationBody((String)this.getResourcesFile(this.highchartJsonTemplate).getAbsolutePath(), Arrays.asList("Category1", "Category2"), charts);
        String er = this.readErFromFile(this.getResourcesFile("highchartRequestBody.json").getAbsolutePath());
        Assertions.assertEquals((Object)er, (Object)act);
    }

    private String readErFromFile(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])));
    }

    @Test
    public void statisticsService_checkAvailabilityForProjectD_returnsAvailabilityStatistics() {
        this.setUp();
        ArrayList<GeneralStatisticsItem> expectedStatistics = new ArrayList<GeneralStatisticsItem>();
        GeneralStatisticsItem statistics = new GeneralStatisticsItem(TABLE_TITLE, Long.valueOf(9L), Long.valueOf(3L), Long.valueOf(0L), Long.valueOf(12L));
        statistics.setEnvironment(DEFAULT_ASSIGNMENT);
        statistics.setSystem(DEFAULT_ASSIGNMENT);
        statistics.setDetails(Arrays.asList(this.availableItemFirst, this.availableItemSecond));
        expectedStatistics.add(statistics);
        List actualStatistics = this.statisticsService.getTestDataAvailability(projectId, null);
        List details = ((GeneralStatisticsItem)actualStatistics.get(0)).getDetails().stream().sorted(Comparator.comparingLong(GeneralStatisticsItem::getOccupied)).collect(Collectors.toList());
        actualStatistics.forEach(x -> x.setDetails(details));
        Assertions.assertEquals(expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOnEnvironmentDays_returnsConsumptionStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter));
        dates.add(LocalDate.now().plusDays(1L).format(formatter));
        ArrayList<ConsumedStatisticsItem> expectedConsumedList = new ArrayList<ConsumedStatisticsItem>();
        expectedConsumedList.add(this.consumedItemFirstDays);
        this.cleanUp();
        ConsumedStatistics expectedStatistics = new ConsumedStatistics(dates, expectedConsumedList);
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, systemId, LocalDate.now(), LocalDate.now().plusDays(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOnEnvironmentWeeks_returnsConsumptionStatistics() {
        this.setUp();
        List dates = DataUtils.getStatisticsInterval((LocalDate)LocalDate.now(), (LocalDate)LocalDate.now().plusWeeks(1L));
        ArrayList<ConsumedStatisticsItem> expectedConsumedList = new ArrayList<ConsumedStatisticsItem>();
        expectedConsumedList.add(this.consumedItemFirstWeeks);
        this.cleanUp();
        ConsumedStatistics expectedStatistics = new ConsumedStatistics(dates, expectedConsumedList);
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, systemId, LocalDate.now(), LocalDate.now().plusWeeks(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOnEnvironmentMonths_returnsConsumptionStatistics() {
        this.setUp();
        List dates = DataUtils.getStatisticsInterval((LocalDate)LocalDate.now(), (LocalDate)LocalDate.now().plusMonths(1L));
        ArrayList<ConsumedStatisticsItem> expectedConsumedList = new ArrayList<ConsumedStatisticsItem>();
        expectedConsumedList.add(this.consumedItemFirstMonths);
        this.cleanUp();
        ConsumedStatistics expectedStatistics = new ConsumedStatistics(dates, expectedConsumedList);
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, systemId, LocalDate.now(), LocalDate.now().plusMonths(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOnEnvironmentYears_returnsConsumptionStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter) + " year");
        dates.add(LocalDate.now().plusYears(1L).format(formatter) + " year");
        ArrayList<ConsumedStatisticsItem> expectedConsumedList = new ArrayList<ConsumedStatisticsItem>();
        expectedConsumedList.add(this.consumedItemFirstDays);
        this.cleanUp();
        ConsumedStatistics expectedStatistics = new ConsumedStatistics(dates, expectedConsumedList);
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, systemId, LocalDate.now(), LocalDate.now().plusYears(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingForProjectDays_returnsConsumptionStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter));
        dates.add(LocalDate.now().plusDays(1L).format(formatter));
        ConsumedStatisticsItem statisticsItem = new ConsumedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(3L);
                this.add(0L);
            }
        });
        statisticsItem.setEnvironment(DEFAULT_ASSIGNMENT);
        statisticsItem.setSystem(DEFAULT_ASSIGNMENT);
        statisticsItem.setDetails(Arrays.asList(this.consumedItemFirstDays, this.consumedItemSecond));
        ArrayList<ConsumedStatisticsItem> statistics = new ArrayList<ConsumedStatisticsItem>();
        statistics.add(statisticsItem);
        this.cleanUp();
        ConsumedStatistics expectedStatistics = new ConsumedStatistics(dates, statistics);
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, null, LocalDate.now(), LocalDate.now().plusDays(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOutdatedOnEnvironmentDays_returnsConsumptionStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter));
        dates.add(LocalDate.now().plusDays(1L).format(formatter));
        ArrayList<OutdatedStatisticsItem> expectedConsumedOutdatedList = new ArrayList<OutdatedStatisticsItem>();
        expectedConsumedOutdatedList.add(this.outdatedItemFirst);
        OutdatedStatistics expectedStatistics = new OutdatedStatistics(dates, expectedConsumedOutdatedList);
        OutdatedStatistics actualStatistics = this.statisticsService.getTestDataConsumptionWhitOutdated(projectId, systemId, LocalDate.now(), LocalDate.now().plusDays(1L), 1);
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOutdatedOnEnvironmentWeeks_returnsConsumptionStatistics() {
        this.setUp();
        List dates = DataUtils.getStatisticsInterval((LocalDate)LocalDate.now(), (LocalDate)LocalDate.now().plusWeeks(1L));
        ArrayList<OutdatedStatisticsItem> expectedConsumedOutdatedList = new ArrayList<OutdatedStatisticsItem>();
        expectedConsumedOutdatedList.add(this.outdatedItemFirstWeeks);
        OutdatedStatistics expectedStatistics = new OutdatedStatistics(dates, expectedConsumedOutdatedList);
        OutdatedStatistics actualStatistics = this.statisticsService.getTestDataConsumptionWhitOutdated(projectId, systemId, LocalDate.now(), LocalDate.now().plusWeeks(1L), 1);
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOutdatedOnEnvironmentMonths_returnsConsumptionStatistics() {
        this.setUp();
        List dates = DataUtils.getStatisticsInterval((LocalDate)LocalDate.now(), (LocalDate)LocalDate.now().plusMonths(1L));
        ArrayList<OutdatedStatisticsItem> expectedConsumedOutdatedList = new ArrayList<OutdatedStatisticsItem>();
        expectedConsumedOutdatedList.add(this.outdatedItemFirstMonths);
        OutdatedStatistics expectedStatistics = new OutdatedStatistics(dates, expectedConsumedOutdatedList);
        OutdatedStatistics actualStatistics = this.statisticsService.getTestDataConsumptionWhitOutdated(projectId, systemId, LocalDate.now(), LocalDate.now().plusMonths(1L), 1);
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOutdatedOnEnvironmentYears_returnsConsumptionStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter) + " year");
        dates.add(LocalDate.now().plusYears(1L).format(formatter) + " year");
        ArrayList<OutdatedStatisticsItem> expectedConsumedOutdatedList = new ArrayList<OutdatedStatisticsItem>();
        expectedConsumedOutdatedList.add(this.outdatedItemFirst);
        OutdatedStatistics expectedStatistics = new OutdatedStatistics(dates, expectedConsumedOutdatedList);
        OutdatedStatistics actualStatistics = this.statisticsService.getTestDataConsumptionWhitOutdated(projectId, systemId, LocalDate.now(), LocalDate.now().plusYears(1L), 1);
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkConsumingOutdatedForProjectDays_returnsConsumptionStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter));
        dates.add(LocalDate.now().plusDays(1L).format(formatter));
        OutdatedStatisticsItem statisticsItem = new OutdatedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(9L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(3L);
                this.add(0L);
            }
        }, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
            }
        });
        statisticsItem.setEnvironment(DEFAULT_ASSIGNMENT);
        statisticsItem.setSystem(DEFAULT_ASSIGNMENT);
        statisticsItem.setDetails(Arrays.asList(this.outdatedItemFirst, this.outdatedItemSecond));
        ArrayList<OutdatedStatisticsItem> statistics = new ArrayList<OutdatedStatisticsItem>();
        statistics.add(statisticsItem);
        OutdatedStatistics expectedStatistics = new OutdatedStatistics(dates, statistics);
        OutdatedStatistics actualStatistics = this.statisticsService.getTestDataConsumptionWhitOutdated(projectId, null, LocalDate.now(), LocalDate.now().plusDays(1L), 1);
        List details = ((OutdatedStatisticsItem)actualStatistics.getItems().get(0)).getDetails();
        ArrayList<OutdatedStatisticsItem> detailsSorted = new ArrayList<OutdatedStatisticsItem>();
        OutdatedStatisticsItem buf = null;
        for (OutdatedStatisticsItem x : details) {
            if ((Long)x.getConsumed().get(0) == 1L) {
                detailsSorted.add(x);
                continue;
            }
            buf = x;
        }
        detailsSorted.add(buf);
        ((OutdatedStatisticsItem)actualStatistics.getItems().get(0)).setDetails(detailsSorted);
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkCreatedWhenOnEnvironmentDays_returnsCreatedWhenStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter));
        dates.add(LocalDate.now().plusDays(1L).format(formatter));
        ArrayList<DateStatisticsItem> expectedCreatedWhenList = new ArrayList<DateStatisticsItem>();
        expectedCreatedWhenList.add(this.createdWhenItemFirst);
        this.deleteTestDataTable(TABLE_NAME_SECOND);
        DateStatistics expectedStatistics = new DateStatistics(dates, expectedCreatedWhenList);
        DateStatistics actualStatistics = this.statisticsService.getTestDataCreatedWhen(projectId, systemId, LocalDate.now(), LocalDate.now().plusDays(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkCreatedWhenForProjectDays_returnsCreatedWhenStatistics() {
        this.setUp();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MMM-dd");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().format(formatter));
        dates.add(LocalDate.now().plusDays(1L).format(formatter));
        ConsumedStatisticsItem statisticsItem = new ConsumedStatisticsItem(TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(3L);
                this.add(0L);
            }
        });
        statisticsItem.setEnvironment(DEFAULT_ASSIGNMENT);
        statisticsItem.setSystem(DEFAULT_ASSIGNMENT);
        statisticsItem.setDetails(Arrays.asList(this.consumedItemFirstDays, this.consumedItemSecond));
        ArrayList<ConsumedStatisticsItem> statistics = new ArrayList<ConsumedStatisticsItem>();
        statistics.add(statisticsItem);
        this.cleanUp();
        ConsumedStatistics expectedStatistics = new ConsumedStatistics(dates, statistics);
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, null, LocalDate.now(), LocalDate.now().plusDays(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkReportStatistics_returnsReportStatistics() {
        this.setUp();
        int threshold = 5;
        ArrayList<StatisticsReportElement> upToThreshold = new ArrayList<StatisticsReportElement>();
        StatisticsReportElement reportElementFirst = new StatisticsReportElement();
        StatisticsReportEnvironment envFirst = new StatisticsReportEnvironment(environment.getName(), system.getName());
        GeneralStatisticsItem dataFirst = new GeneralStatisticsItem(TABLE_TITLE, Long.valueOf(5L), Long.valueOf(1L), Long.valueOf(1L), Long.valueOf(6L));
        reportElementFirst.setEnvironment(envFirst);
        reportElementFirst.setData(Collections.singletonList(dataFirst));
        upToThreshold.add(reportElementFirst);
        ArrayList<StatisticsReportElement> downToThreshold = new ArrayList<StatisticsReportElement>();
        StatisticsReportElement reportElementSecond = new StatisticsReportElement();
        StatisticsReportEnvironment envSecond = new StatisticsReportEnvironment(lazyEnvironmentSecond.getName(), systemSecond.getName());
        GeneralStatisticsItem dataSecond = new GeneralStatisticsItem(TABLE_TITLE, Long.valueOf(4L), Long.valueOf(2L), Long.valueOf(2L), Long.valueOf(6L));
        reportElementSecond.setEnvironment(envSecond);
        reportElementSecond.setData(Collections.singletonList(dataSecond));
        downToThreshold.add(reportElementSecond);
        StatisticsReportObject expectedStatistics = new StatisticsReportObject();
        expectedStatistics.setProjectName(lazyProject.getName());
        expectedStatistics.setUpToThreshold(upToThreshold);
        expectedStatistics.setDownToThreshold(downToThreshold);
        StatisticsReportObject actualStatistics = this.statisticsService.getTestDataMonitoringStatistics(projectId, 5);
        this.cleanUp();
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticsService_checkUserStatisticsReport_returnsUserStatisticsReport() {
        this.setUp();
        TestDataTableUsersMonitoring usersMonitoring = this.getTestDataTableUsersMonitoring(this.cron);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMM");
        ArrayList<String> dates = new ArrayList<String>();
        dates.add(LocalDate.now().minusDays(2L).format(formatter));
        dates.add(LocalDate.now().minusDays(1L).format(formatter));
        dates.add(LocalDate.now().format(formatter));
        UserGeneralStatisticsItem itemFirst = new UserGeneralStatisticsItem(lazyEnvironment.getName(), lazySystem.getName(), TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
                this.add(1L);
            }
        });
        UserGeneralStatisticsItem itemSecond = new UserGeneralStatisticsItem(lazyEnvironmentSecond.getName(), lazySystemSecond.getName(), TABLE_TITLE, (List)new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
                this.add(2L);
            }
        });
        ArrayList<UserGeneralStatisticsItem> items = new ArrayList<UserGeneralStatisticsItem>();
        items.add(itemFirst);
        items.add(itemSecond);
        UsersStatisticsReportElement usersStatisticsReportElement = new UsersStatisticsReportElement("TestUser", dates, items);
        ArrayList<UsersStatisticsReportElement> elements = new ArrayList<UsersStatisticsReportElement>();
        elements.add(usersStatisticsReportElement);
        UsersStatisticsReportObject expect = new UsersStatisticsReportObject();
        expect.setProjectName("Test Statistics Project");
        expect.setElements(elements);
        UsersStatisticsReportObject actual = this.statisticsService.getUsersStatisticsReport(usersMonitoring);
        this.cleanUp();
        Assertions.assertEquals((Object)expect, (Object)actual);
    }

    @Test
    public void statisticsService_checkUserStatisticsReport_returnsEmptyUserStatisticsReport() {
        Mockito.when((Object)this.environmentsService.getLazyProjectById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
        TestDataTableUsersMonitoring usersMonitoring = this.getTestDataTableUsersMonitoring(this.cron);
        UsersStatisticsReportObject expect = new UsersStatisticsReportObject();
        expect.setProjectName("Test Statistics Project");
        expect.setElements(null);
        UsersStatisticsReportObject actual = this.statisticsService.getUsersStatisticsReport(usersMonitoring);
        this.cleanUp();
        Assertions.assertEquals((Object)expect, (Object)actual);
    }

    @Test
    public void statisticsService_checkNextScheduledRun_returnsNextScheduledRun() throws ParseException {
        String cronExpression = "0 0 6 * * ?";
        String pattern = "E MMM dd HH:mm:ss z yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        LocalDateTime expectedDateTime = LocalDate.now().atTime(6, 0);
        if (LocalDateTime.now().isAfter(expectedDateTime)) {
            expectedDateTime = expectedDateTime.plusDays(1L);
        }
        String expectedNextRun = simpleDateFormat.format(this.convertToDateViaInstant(expectedDateTime));
        String actualNextRun = this.statisticsService.getNextScheduledRun("0 0 6 * * ?");
        Assertions.assertEquals((Object)expectedNextRun, (Object)actualNextRun);
    }

    private Date convertToDateViaInstant(LocalDateTime dateToConvert) {
        return Date.from(dateToConvert.atZone(ZoneId.systemDefault()).toInstant());
    }

    @Test
    public void statisticsService_saveAndDeleteMonitoringSchedule_scheduleSavedAndDeleted() {
        TestDataTableMonitoring monitoring = this.getTestDataTableMonitoring(this.cron);
        this.statisticsService.saveMonitoringSchedule(monitoring);
        Assertions.assertEquals((Object)monitoring, (Object)this.statisticsService.getMonitoringSchedule(projectId));
        this.statisticsService.deleteMonitoringSchedule(monitoring);
        Assertions.assertEquals((Object)new TestDataTableMonitoring(), (Object)this.statisticsService.getMonitoringSchedule(projectId));
    }

    @Test
    public void statisticsService_checkConsumingForDroppedTable_returnsConsumptionStatistics() {
        this.setUp();
        ConsumedStatistics expectedStatistics = this.statisticsService.getTestDataConsumption(projectId, null, LocalDate.now(), LocalDate.now().plusDays(1L));
        this.cleanUp();
        ConsumedStatistics actualStatistics = this.statisticsService.getTestDataConsumption(projectId, null, LocalDate.now(), LocalDate.now().plusDays(1L));
        Assertions.assertEquals((Object)expectedStatistics, (Object)actualStatistics);
    }

    @Test
    public void statisticService_getStatisticsByUsers_returnRightRowsCount() {
        this.setUp();
        this.mockEnvForStatistics();
        UsersOccupyStatisticResponse respone = this.statisticsService.getOccupiedDataByUsers(this.usersOccupyStatisticRequest);
        Assertions.assertEquals((int)respone.getRecords(), (int)2);
    }

    @Test
    public void statisticService_getStatisticsByUsers_returnOrderedTableTitle() {
        this.setUp();
        this.mockEnvForStatistics();
        UsersOccupyStatisticResponse response = this.statisticsService.getOccupiedDataByUsers(this.usersOccupyStatisticRequest);
        Assertions.assertEquals((Object)((OccupiedDataByUsersStatistics)response.getData().get(0)).getContext(), (Object)TABLE_TITLE);
    }

    @Test
    public void statisticService_getStatisticsByUsers_returnUsersStatistics() {
        this.setUp();
        this.mockEnvForStatistics();
        UsersOccupyStatisticResponse response = this.statisticsService.getOccupiedDataByUsers(this.usersOccupyStatisticRequest);
        Assertions.assertEquals((Object)((OccupiedDataByUsersStatistics)response.getData().get(1)).getUserName(), (Object)"TestUser");
    }

    @Test
    public void statisticsService_getUsersMonitoringSchedule_successfulGet() {
        TestDataTableUsersMonitoring usersMonitoring = this.getTestDataTableUsersMonitoring(this.cron);
        this.statisticsService.saveUsersMonitoringSchedule(usersMonitoring);
        TestDataTableUsersMonitoring actual = this.statisticsService.getUsersMonitoringSchedule(projectId);
        Assertions.assertEquals((Object)usersMonitoring, (Object)actual);
    }

    @Test
    public void statisticsService_saveUsersMonitoringSchedule_successfulGet() {
        UUID newProject = UUID.randomUUID();
        TestDataTableUsersMonitoring usersMonitoring = this.getTestDataTableUsersMonitoring(this.cron);
        usersMonitoring.setProjectId(newProject);
        this.statisticsService.saveUsersMonitoringSchedule(usersMonitoring);
        Assertions.assertEquals((Object)this.statisticsService.getUsersMonitoringSchedule(newProject), (Object)usersMonitoring);
    }

    @Test
    public void deleteUsersMonitoringSchedule() {
        TestDataTableUsersMonitoring usersMonitoring = this.getTestDataTableUsersMonitoring(this.cron);
        this.statisticsService.saveUsersMonitoringSchedule(usersMonitoring);
        this.statisticsService.deleteUsersMonitoringSchedule(usersMonitoring);
        TestDataTableUsersMonitoring actual = this.statisticsService.getUsersMonitoringSchedule(projectId);
        Assertions.assertEquals((Object)new TestDataTableUsersMonitoring(), (Object)actual);
    }

    private TestDataTableMonitoring getTestDataTableMonitoring(String cron) {
        TestDataTableMonitoring monitoring = new TestDataTableMonitoring();
        monitoring.setProjectId(projectId);
        monitoring.setEnabled(true);
        monitoring.setCronExpression(cron);
        monitoring.setThreshold(10);
        monitoring.setRecipients("example@example.com");
        return monitoring;
    }

    private TestDataTableUsersMonitoring getTestDataTableUsersMonitoring(String cron) {
        TestDataTableUsersMonitoring usersMonitoring = new TestDataTableUsersMonitoring();
        usersMonitoring.setProjectId(projectId);
        usersMonitoring.setEnabled(true);
        usersMonitoring.setCronExpression(cron);
        usersMonitoring.setRecipients("example1@example.com,example2@example.com");
        usersMonitoring.setDaysCount(2);
        usersMonitoring.setHtmlReport(true);
        usersMonitoring.setCsvReport(true);
        return usersMonitoring;
    }

    @Test
    public void availableDataMonitoring_saveConfig_configInDb() throws Exception {
        this.setUp();
        this.createEmptyMonitoringConfig();
        TestAvailableDataMonitoring config = StatisticsServiceTest.createMonitoringConfig();
        this.statisticsService.saveAvailableDataMonitoringConfig(config);
        TestAvailableDataMonitoring savedConfig = this.statisticsService.getAvailableDataMonitoringConfig(config.getSystemId(), config.getEnvironmentId());
        Assertions.assertEquals((Object)config, (Object)savedConfig);
    }

    @Test
    public void availableDataMonitoring_deleteConfig_dataCleaned() throws Exception {
        this.setUp();
        this.createEmptyMonitoringConfig();
        TestAvailableDataMonitoring config = StatisticsServiceTest.createMonitoringConfig();
        this.statisticsService.saveAvailableDataMonitoringConfig(config);
        this.statisticsService.deleteAvailableDataMonitoringConfig(systemId, environmentId);
        TestAvailableDataMonitoring configFromDb = this.statisticsService.getAvailableDataMonitoringConfig(systemId, environmentId);
        Assertions.assertTrue((boolean)StringUtils.isEmpty((CharSequence)configFromDb.getRecipients()));
        Assertions.assertTrue((boolean)StringUtils.isEmpty((CharSequence)configFromDb.getSchedule()));
        Assertions.assertFalse((boolean)configFromDb.isScheduled());
    }

    @Test
    public void availableStatistic_getNewConfig_getConfig() {
        String tableName = "availabledata_" + System.currentTimeMillis();
        UUID system2 = UUID.randomUUID();
        UUID project = UUID.randomUUID();
        try {
            List<String> columns = Arrays.asList("sim", "Status", "Partner", "Partner category", "Partner ID", "Operator ID", "environment", "Assignment");
            this.createTestDataTable(tableName);
            this.createTestDataTableCatalog(project, system2, environmentId, "availableData", tableName);
            AvailableDataStatisticsConfig config = this.statisticsService.getAvailableStatsConfig(system2, environmentId);
            Assertions.assertTrue((boolean)config.getColumnKeys().containsAll(columns));
            Assertions.assertNull((Object)config.getDescription());
            Assertions.assertNull((Object)config.getActiveColumnKey());
            Assertions.assertNull((Object)config.getTablesColumns());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void availableStatistic_saveConfig_saved() {
        UUID system2 = UUID.randomUUID();
        UUID project = UUID.randomUUID();
        String tableName = "availabledata2_" + System.currentTimeMillis();
        try {
            this.createTestDataTable(tableName);
            this.createTestDataTableCatalog(project, system2, environmentId, "availableData2", tableName);
            AvailableDataStatisticsConfig config = this.statisticsService.getAvailableStatsConfig(system2, environmentId);
            List values = this.testDataService.getDistinctTablesColumnValues(system2, environmentId, "sim");
            config.setTablesColumns(values);
            config.setDescription("Descirption");
            config.setActiveColumnKey("sim");
            this.statisticsService.saveAvailableStatsConfig(config);
            AvailableDataStatisticsConfig actConfig = this.statisticsService.getAvailableStatsConfig(system2, environmentId);
            Assertions.assertEquals((Object)config, (Object)actConfig);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void availableData_getAvailableData_returnStatistic() {
        UUID system2 = UUID.randomUUID();
        UUID project = UUID.randomUUID();
        String tableName = "gettingdata_" + System.currentTimeMillis();
        try {
            this.createTestDataTable(tableName);
            this.createTestDataTableCatalog(project, system2, environmentId, "gettingData", tableName);
            AvailableDataStatisticsConfig config = this.statisticsService.getAvailableStatsConfig(system2, environmentId);
            List values = this.testDataService.getDistinctTablesColumnValues(system2, environmentId, "sim");
            ((TableColumnValues)values.get(0)).getValues().add("Empty stat");
            config.setTablesColumns(values);
            config.setDescription("Descirption");
            config.setActiveColumnKey("sim");
            this.statisticsService.saveAvailableStatsConfig(config);
            AvailableDataByColumnStats stats = this.statisticsService.getAvailableDataInColumn(system2, environmentId);
            Assertions.assertEquals((Integer)new Integer(0), (Integer)((Integer)((TableAvailableDataStats)stats.getStatistics().get(0)).getOptions().get("Empty stat")));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    private static TestAvailableDataMonitoring createMonitoringConfig() {
        TestAvailableDataMonitoring availableDataMonitoring = new TestAvailableDataMonitoring();
        availableDataMonitoring.setSystemId(systemId);
        availableDataMonitoring.setEnvironmentId(environmentId);
        availableDataMonitoring.setActiveColumn("SIM");
        availableDataMonitoring.setDescription("Config name");
        availableDataMonitoring.setThreshold(10);
        availableDataMonitoring.setScheduled(true);
        availableDataMonitoring.setSchedule("0 0 9 ? * *");
        availableDataMonitoring.setRecipients("example@example.com");
        return availableDataMonitoring;
    }

    private TestAvailableDataMonitoring createEmptyMonitoringConfig() {
        TestAvailableDataMonitoring availableDataMonitoring = new TestAvailableDataMonitoring();
        availableDataMonitoring.setSystemId(systemId);
        availableDataMonitoring.setEnvironmentId(environmentId);
        availableDataMonitoring.setActiveColumn("SIM");
        availableDataMonitoring.setDescription("Config name");
        availableDataMonitoring.setThreshold(10);
        this.availableDataMonitoringRepository.save((Object)availableDataMonitoring);
        return availableDataMonitoring;
    }
}

