/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.util.ArrayList;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.table.TestDataFlagsTable;
import org.qubership.atp.tdm.repo.TestDataColumnFlagsRepository;
import org.qubership.atp.tdm.service.impl.TestDataFlagsServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class TestDataFlagsServiceTest
extends AbstractTestDataTest {
    @Autowired
    protected TestDataFlagsServiceImpl testDataFlagsService;
    @Autowired
    protected TestDataColumnFlagsRepository testDataColumnFlagsRepository;

    @Test
    public void testDataFlagsService_setValidateUnoccupiedResourcesFlag_flagSet() {
        UUID projectId = UUID.randomUUID();
        String tableName = "tdm_test_data_setup_validate_unoccupied_resources_flag";
        String tableTitle = "Tdm Test Data Setup Validate Unoccupied Resources Flag";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        TestDataFlagsTable expectedTestDataFlagsTable = new TestDataFlagsTable(tableName, false);
        this.testDataFlagsService.setValidateUnoccupiedResourcesFlag(tableName, Boolean.valueOf(false), Boolean.valueOf(false));
        TestDataFlagsTable actualTestDataFlagsTable = this.testDataColumnFlagsRepository.findRowByTableName(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals((Object)expectedTestDataFlagsTable, (Object)actualTestDataFlagsTable);
    }

    @Test
    public void testDataFlagsService_bulkSetValidateUnoccupiedResourcesFlag_flagsSet() {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            tableNames.add(UUID.randomUUID().toString());
        }
        tableNames.forEach(tableName -> this.createTestDataTableCatalog(projectId, systemId, environmentId, "bulkFlagsSet", (String)tableName));
        this.testDataFlagsService.setValidateUnoccupiedResourcesFlag((String)tableNames.get(0), Boolean.valueOf(false), Boolean.valueOf(true));
        int flagsTablesSize = (int)tableNames.stream().map(tableName -> this.testDataColumnFlagsRepository.findRowByTableName(tableName)).count();
        Assertions.assertEquals((int)tableNames.size(), (int)flagsTablesSize);
    }
}

