/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.ExcelRowsReader;
import org.qubership.atp.tdm.model.DropResults;
import org.qubership.atp.tdm.model.EnvsList;
import org.qubership.atp.tdm.model.ImportTestDataStatistic;
import org.qubership.atp.tdm.model.ProjectInformation;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.table.TableColumnValues;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public class TestDataServiceTest
extends AbstractTestDataTest {
    private static final String TEST_DATASET = "DataSet.xlsx";
    private static final String TEST_DATASET_SMALL = "DataSetSmall.xlsx";
    private static final String TABLE_TO_EXCEL_FILE = "TableToExcel.xlsx";
    private static final String TABLE_TO_CSV_FILE = "TableToCsv.csv";
    private static final int CREATED_WHEN_COLUMN_INDEX = 3;
    private static final int OCCUPIED_DATE_COLUMN_INDEX = 1;

    @BeforeEach
    public void setUp() throws Exception {
        Mockito.when((Object)this.environmentsService.getLazyProjectById((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyProject);
        Mockito.when((Object)this.environmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)system);
        Mockito.when((Object)this.environmentsService.getLazyEnvironment((UUID)ArgumentMatchers.any())).thenReturn((Object)lazyEnvironment);
        Mockito.when((Object)this.environmentsService.getEnvNameById((UUID)ArgumentMatchers.any())).thenReturn((Object)"Test Environment");
        Mockito.when((Object)this.environmentsService.getLazyEnvironmentsShort((UUID)ArgumentMatchers.any())).thenReturn(Collections.singletonList(lazyEnvironment));
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn((Object)connections);
    }

    @Test
    public void testDataTablesCatalog_getCatalogOnlyProjectSelected_returnNormalCatalog() {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(UUID.randomUUID(), null, null, "Test Table Only Project", "table_name_project");
        List catalogList = this.testDataService.getTestDataTablesCatalog(catalog.getProjectId(), catalog.getSystemId());
        this.catalogRepository.deleteByTableName("table_name_project");
        Assertions.assertEquals((Object)((TestDataTableCatalog)catalogList.get(0)).getTableName(), (Object)catalog.getTableName());
    }

    @Test
    public void testDataTablesCatalog_getCatalogSystemAndProjectSelected_returnNormalCatalog() {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), "Test Table, Project and System", "table_name_project_system");
        List catalogList = this.testDataService.getTestDataTablesCatalog(catalog.getProjectId(), catalog.getSystemId());
        this.catalogRepository.deleteByTableName("table_name_project_system");
        Assertions.assertEquals((Object)((TestDataTableCatalog)catalogList.get(0)).getTableName(), (Object)catalog.getTableName());
    }

    @Test
    public void testDataTablesCatalog_getCatalogNotExistSystemAndProjectSelected_returnEmptyArray() {
        String tableName = "table_name_project_and_not_exist_system";
        String tableTitle = "Test Table Project and Not Exist System";
        UUID notExistSystemId = UUID.randomUUID();
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableTitle, tableName);
        List tablesCatalog = this.testDataService.getTestDataTablesCatalog(catalog.getProjectId(), notExistSystemId);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((int)tablesCatalog.size(), (int)0);
    }

    @Test
    public void testDataTablesCatalog_getCatalogNotExistProjectSelected_returnEmptyArray() {
        String tableName = "table_name_not_exist_project";
        String tableTitle = "Test Table Not Exist Project";
        UUID notExistProjectId = UUID.randomUUID();
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableTitle, tableName);
        List tablesCatalog = this.testDataService.getTestDataTablesCatalog(notExistProjectId, null);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((int)tablesCatalog.size(), (int)0);
    }

    @Test
    public void testDataTable_getTableByTableName_returnNormalTestDataTable() {
        String tableName = "tdm_test_get_test_data";
        TestDataTable expectedTable = this.createTestDataTable(tableName);
        TestDataTable actualTable = this.testDataService.getTestData(tableName);
        for (int rowNum = 0; rowNum < expectedTable.getData().size() - 1; ++rowNum) {
            Map expectedRow = (Map)expectedTable.getData().get(rowNum);
            Map actualRow = (Map)actualTable.getData().get(rowNum);
            for (String key : expectedRow.keySet()) {
                Object expectedValue = expectedRow.get(key);
                Object actualValue = actualRow.get(key);
                Assertions.assertEquals(expectedValue, actualValue);
            }
        }
        this.deleteTestDataTableIfExists(tableName);
    }

    @Test
    public void testDataTable_getTableWithAppliedFilterTypeContains_returnSelectedWithFilterTable() {
        String tableName = "tdm_test_get_test_data_filter_contains";
        this.createTestDataTable(tableName, true);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter simColumnFilter = new TestDataTableFilter("sim", "contains", Collections.singletonList("0126072004014082"), false);
        filters.add(simColumnFilter);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals((Object)"8901260720040140822", ((Map)actualTable.getData().get(0)).get("sim"));
    }

    @Test
    public void testDataTable_getTableWithAppliedFilterTypeEquals_returnSelectedWithFilterTable() {
        String tableName = "tdm_test_get_test_data_filter_equals";
        this.createTestDataTable(tableName, true);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter simColumnFilter = new TestDataTableFilter("sim", "equals", Collections.singletonList("8901260720040140973"), false);
        filters.add(simColumnFilter);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals((Object)"8901260720040140973", ((Map)actualTable.getData().get(0)).get("sim"));
    }

    @Test
    public void testDataTable_getTableWithAppliedFilterTypeDate_returnSelectedDataWithFilterTable() {
        String tableName = "tdm_test_get_test_data_filter_date_positive";
        this.createTestDataTable(tableName, true);
        LocalDate currentDate = LocalDate.now();
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        List<String> filterValues = Collections.singletonList(String.valueOf(currentDate));
        TestDataTableFilter fromColumnFilter = new TestDataTableFilter("CREATED_WHEN", "From", filterValues, false);
        filters.add(fromColumnFilter);
        TestDataTableFilter toColumnFilter = new TestDataTableFilter("CREATED_WHEN", "To", filterValues, false);
        filters.add(toColumnFilter);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals((int)6, (int)actualTable.getData().size());
    }

    @Test
    public void testDataTable_getTableWithAppliedFilterTypeDate_returnSelectedNothingWithFilterTable() {
        String tableName = "tdm_test_get_test_data_filter_date_negative";
        this.createTestDataTable(tableName, true);
        LocalDate nextDate = LocalDate.now().plusDays(1L);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        List<String> filterValues = Collections.singletonList(String.valueOf(nextDate));
        TestDataTableFilter fromColumnFilter = new TestDataTableFilter("CREATED_WHEN", "From", filterValues, false);
        filters.add(fromColumnFilter);
        TestDataTableFilter toColumnFilter = new TestDataTableFilter("CREATED_WHEN", "To", filterValues, false);
        filters.add(toColumnFilter);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertTrue((boolean)actualTable.getData().isEmpty());
    }

    @Test
    public void testDataTable_getTableWithAppliedFilterTypeStartWith_returnSelectedWithFilterTable() {
        String tableName = "tdm_test_get_test_data_filter_start_with";
        this.createTestDataTable(tableName, true);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter simColumnFilter = new TestDataTableFilter("sim", "startWith", Collections.singletonList("890126072004014082"), false);
        filters.add(simColumnFilter);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals((Object)"8901260720040140822", ((Map)actualTable.getData().get(0)).get("sim"));
    }

    @Test
    public void testDataTable_getTableWithFilterTypeCaseSensitive_returnSelectedWithFilterTable() {
        String tableName = "tdm_test_get_test_data_filter_case_sensitive";
        this.createTestDataTable(tableName, true);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter simColumnFilter = new TestDataTableFilter("Assignment", "contains", Collections.singletonList("TeSt AutoMatioN"), true);
        filters.add(simColumnFilter);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals((Object)"TeSt AutoMatioN 2", ((Map)actualTable.getData().get(0)).get("Assignment"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataTable_getTableWithWrongFilterType_throwsException() {
        String tableName = "tdm_test_get_test_data_wrong_filter";
        this.createTestDataTable(tableName, true);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter simColumnFilter = new TestDataTableFilter("sim", "end_with", Collections.singletonList("0126072004014082"), false);
        filters.add(simColumnFilter);
        try {
            this.testDataService.getTestData(tableName, null, null, filters, null, Boolean.valueOf(false));
        }
        catch (InvalidDataAccessApiUsageException e) {
            String message = "Unknown search condition type: end_with; nested exception is java.lang.IllegalArgumentException: Unknown search condition type: end_with";
            Assertions.assertEquals((Object)message, (Object)e.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
        }
    }

    @Test
    public void testDataTable_getTableUsingOffsetAndLimitMethod_valuesAreNotEqual() {
        String tableName = "tdm_test_get_test_data_offset_and_limit";
        TestDataTable expectedTable = this.createTestDataTable(tableName, true);
        TestDataTable actualTable = this.testDataService.getTestData(tableName, Integer.valueOf(3), Integer.valueOf(1), new ArrayList(), null, Boolean.valueOf(false));
        Map expectedRow = (Map)expectedTable.getData().get(3);
        Map actualRow = (Map)actualTable.getData().get(0);
        for (String key : expectedRow.keySet()) {
            Object expectedValue = expectedRow.get(key);
            Object actualValue = actualRow.get(key);
            MatcherAssert.assertThat((String)"Values are not equal.", expectedValue, (Matcher)CoreMatchers.is(actualValue));
        }
        this.deleteTestDataTableIfExists(tableName);
    }

    @Test
    public void testDataService_getOccupiedRows_returnOnlyOccupiedRows() {
        String tableName = "tdm_test_get_occupied_rows_test_data_one";
        try {
            this.createTestDataTable(tableName);
            TestDataTable table = this.testDataService.getTestData(tableName);
            List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
            this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableName, tableName);
            this.testDataService.occupyTestData(tableName, "TestUser1", rowIdsToOccupy);
            table = this.testDataService.getTestData(tableName, null, null, new ArrayList(), null, Boolean.valueOf(true));
            List<UUID> actualRowIds = this.extractRowIds(table.getData());
            Assertions.assertEquals(actualRowIds, rowIdsToOccupy);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataService_getOccupiedRows_rowsAlreadyOccupied() {
        String tableName = "tdm_test_get_occupied_test_data";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableName, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser1", rowIdsToOccupy);
        try {
            this.testDataService.occupyTestData(tableName, "TestUser1", rowIdsToOccupy);
        }
        catch (RuntimeException re) {
            String message = "Error: object(s) already occupied. Please refresh table and try again.";
            Assertions.assertEquals((Object)message, (Object)re.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void importExcelTestData_addNewColumnsToTable_newColumnsCreationAndFill() throws IOException {
        UUID projectId = UUID.randomUUID();
        String tableTitle = "tdm_test_import_excel_new_columns_test_data";
        try {
            this.testDataService.importExcelTestData(projectId, null, null, tableTitle, Boolean.valueOf(false), this.toMultipartFile(this.getResourcesFile(TEST_DATASET_SMALL)));
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Please select Environment and System.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDataService_deleteProjectFromCatalogue_catalogsDeleted() {
        TestDataTableCatalog catalog = this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), "Test Table, Project and System", "table_name_project_system");
        this.createTestDataTable(catalog.getTableName());
        this.projectInformationService.saveProjectInformation(new ProjectInformation(catalog.getProjectId(), "GMT+03:00", "d MMM yyyy", "hh:mm:ss a", 1L));
        this.testDataService.deleteProjectFromCatalogue(catalog.getProjectId());
        this.deleteTestDataTableIfExists("table_name_project_system");
        this.catalogRepository.deleteByTableName("table_name_project_system");
        Assertions.assertTrue((boolean)this.catalogRepository.findAllByProjectId(catalog.getProjectId()).isEmpty());
    }

    private void validateImportTestDataResult(UUID projectId, UUID systemId, int rowCount, String tableTitle) {
        List tableCatalogs = this.testDataService.getTestDataTablesCatalog(projectId, systemId);
        TestDataTableCatalog result = tableCatalogs.stream().filter(t -> tableTitle.equals(t.getTableTitle())).findFirst().orElseThrow(() -> new RuntimeException(String.format("Table with title [%s] was not found.", tableTitle)));
        Assertions.assertNotNull((Object)result);
        TestDataTable testDataTable = this.testDataService.getTestData(result.getTableName());
        Assertions.assertEquals((int)rowCount, (int)testDataTable.getRecords());
    }

    @Test
    public void testDataService_occupyTestData_successfullyOccupyOnlySelectedRows() {
        String tableName = "tdm_test_occupy_test_data";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableName, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser2", rowIdsToOccupy);
        table = this.testDataService.getTestData(tableName);
        List<UUID> actualRowIds = this.extractRowIds(table.getData());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertFalse((boolean)actualRowIds.containsAll(rowIdsToOccupy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void occupyTestData_testDataAlreadyOccupied_returnErrorMessage() {
        String tableName = "tdm_test_occupy_test_data_error";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableName, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser2", rowIdsToOccupy);
        table = this.testDataService.getTestData(tableName);
        this.extractRowIds(table.getData());
        try {
            this.testDataService.occupyTestData(tableName, "TestUser3", rowIdsToOccupy);
        }
        catch (RuntimeException re) {
            String message = "Error: object(s) already occupied. Please refresh table and try again.";
            Assertions.assertEquals((Object)message, (Object)re.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void testDataService_releaseOccupiedData_successfulReleaseOnlySelectedRows() {
        String tableName = "tdm_test_release_test_data";
        String tableTitle = "TDM Test Release Test Data";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableTitle, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser3", rowIdsToOccupy);
        table = this.testDataService.getTestData(tableName);
        List<UUID> actualRowIds = this.extractRowIds(table.getData());
        Assertions.assertFalse((boolean)actualRowIds.containsAll(rowIdsToOccupy));
        this.testDataService.releaseTestData(tableName, rowIdsToOccupy);
        table = this.testDataService.getTestData(tableName);
        actualRowIds = this.extractRowIds(table.getData());
        Assertions.assertTrue((boolean)actualRowIds.containsAll(rowIdsToOccupy));
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void testDataService_deleteTableByTableName_successfulDeleteActualTable() {
        String tableName = "tdm_test_delete_test_data";
        String tableTitle = "TDM Test Delete Test Data";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableTitle, tableName);
        DropResults dropResults = this.testDataService.deleteTestData(tableName);
        Assertions.assertEquals((Object)tableName, (Object)dropResults.getTableName());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void testDataService_truncateDataInTableByTableName_successfullyTruncated() {
        String tableName = "tdm_test_truncate_table";
        UUID projectId = UUID.randomUUID();
        UUID systemId = UUID.randomUUID();
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, UUID.randomUUID(), tableName, tableName);
        this.testDataService.truncateDataInTable(tableName, projectId, systemId);
        TestDataTable table = this.testDataService.getTestData(tableName);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((int)0, (int)table.getRecords());
    }

    @Test
    public void testDataService_truncateDataInTableByTableName_tableNotFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String tableName = "tdm_truncate_table_table_not_found";
            this.testDataService.truncateDataInTable(tableName, UUID.randomUUID(), UUID.randomUUID());
        });
    }

    @Test
    public void testDataService_deleteSeveralRowsInTableByIds_successfulDeleteOfSelectedRows() {
        String tableName = "tdm_test_delete_rows";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableName, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToDelete = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.deleteTestDataTableRows(tableName, rowIdsToDelete);
        TestDataTable actualTable = this.testDataService.getTestData(tableName);
        List<UUID> actualRowIds = this.extractRowIds(actualTable.getData());
        Assertions.assertFalse((boolean)actualRowIds.containsAll(rowIdsToDelete));
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
    }

    @Test
    public void testDataService_deleteSeveralOccupiedRowsInTableByIds_successfulDeleteOfSelectedRows() {
        String tableName = "tdm_test_delete_occupied_rows";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), tableName, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToDelete = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser3", rowIdsToDelete);
        this.testDataService.deleteTestDataTableRows(tableName, rowIdsToDelete);
        TestDataTable actualTable = this.testDataTableRepository.getFullTestData(tableName);
        List<UUID> actualRowIds = this.extractRowIds(actualTable.getData());
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertFalse((boolean)actualRowIds.containsAll(rowIdsToDelete));
    }

    @Test
    public void testDataService_getTestDataTableAsExcelFile_returnDocumentWithEqualTable() throws IOException {
        String tableName = "tdm_test_get_table_as_excel";
        String tableTitle = "TDM Test Get Table As Excel";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        TestDataTable table = this.testDataService.getTestData(tableName);
        List<UUID> rowIdsToOccupy = this.extractRowIds(table.getData().subList(0, 2));
        this.testDataService.occupyTestData(tableName, "TestUser3", rowIdsToOccupy);
        File erFile = this.getResourcesFile(TABLE_TO_EXCEL_FILE);
        File arFile = this.testDataService.getTestDataTableAsExcelFile(tableName);
        List erRows = ExcelRowsReader.read(erFile).collect(Collectors.toList());
        List erRowsPerformed = ExcelRowsReader.read(erFile).collect(Collectors.toList());
        List arRows = ExcelRowsReader.read(arFile).collect(Collectors.toList());
        for (int j = 1; j < erRows.size(); ++j) {
            ((List)erRowsPerformed.get(j)).set(3, (String)((List)arRows.get(j)).get(3));
            ((List)erRowsPerformed.get(j)).set(1, (String)((List)arRows.get(j)).get(1));
        }
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(erRowsPerformed, arRows);
    }

    @Test
    public void testDataService_getTestDataTableAsCsvFile_returnDocumentWithEqualTable() throws IOException {
        String tableName = "tdm_test_get_table_as_csv";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, "table_title", tableName);
        this.createTestDataTable(tableName);
        File erFile = this.getResourcesFile(TABLE_TO_CSV_FILE);
        File arFile = this.testDataService.getTestDataTableAsCsvFile(tableName);
        List<String> erRows = Files.readAllLines(erFile.toPath());
        ArrayList<String> erRowsPerformed = new ArrayList<String>();
        List<String> arRows = Files.readAllLines(arFile.toPath());
        ArrayList<String[]> splitList = new ArrayList<String[]>();
        for (String row : arRows) {
            splitList.add(row.split(","));
        }
        int j = 0;
        erRowsPerformed.add(erRows.get(0));
        for (String element : erRows.subList(1, erRows.size())) {
            String[] splitDemo = element.split(",");
            String[] splitResult = new String[splitDemo.length + 1];
            StringBuilder resultToReplace = new StringBuilder();
            System.arraycopy(splitDemo, 0, splitResult, 0, 3);
            for (int i = 3; i < splitResult.length; ++i) {
                if (i == 3) {
                    splitResult[3] = ((String[])splitList.get(++j))[3];
                    continue;
                }
                splitResult[i] = splitDemo[i - 1];
            }
            resultToReplace.append(splitResult[0]);
            for (int k = 1; k < splitResult.length; ++k) {
                resultToReplace.append(",").append(splitResult[k]);
            }
            erRowsPerformed.add(resultToReplace.toString());
        }
        this.deleteTestDataTableIfExists(tableName);
        Assertions.assertEquals(erRowsPerformed, arRows);
    }

    @Test
    public void testDataService_importSqlTestData_rowsImportedAndStatisticReturned() {
        this.createTestDataTable("tdm_test_import_sql_source_table");
        String targetTableTitle = "TDM Test import sql";
        String targetTableName = "tdm_test_import_sql";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName);
        this.createTestDataTable(targetTableName);
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        ImportTestDataStatistic statistic = new ImportTestDataStatistic("Test Environment", null, Integer.valueOf(6));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), "Test System", targetTableTitle, "select sim from tdm_test_import_sql_source_table", Integer.valueOf(30));
        this.deleteTestDataTableIfExists("tdm_test_import_sql_source_table");
        this.deleteTestDataTableIfExists("tdm_test_import_sql");
        this.catalogRepository.deleteByTableName("tdm_test_import_sql");
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_importSqlTestDataInNewTable_rowsImportedAndStatisticReturned() {
        this.createTestDataTable("tdm_test_import_sql_source_table_new");
        String targetTableTitle = "TDM Test import sql new";
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        ImportTestDataStatistic statistic = new ImportTestDataStatistic("Test Environment", null, Integer.valueOf(6));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), "Test System", targetTableTitle, "select sim from tdm_test_import_sql_source_table_new", Integer.valueOf(30));
        String newTableName = this.catalogRepository.findByProjectIdAndSystemIdAndTableTitle(projectId, systemId, targetTableTitle).getTableName();
        this.deleteTestDataTableIfExists("tdm_test_import_sql_source_table_new");
        this.deleteTestDataTableIfExists(newTableName);
        this.catalogRepository.deleteByTableName(newTableName);
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_importSqlTestDataEmptyRequest_returnErrorMessage() {
        this.createTestDataTable("tdm_test_import_sql_source_table_new_empty_request");
        String targetTableTitle = "TDM Test import sql new empty request";
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        ImportTestDataStatistic statistic = new ImportTestDataStatistic("Test Environment", "Import by sql. SQL request return 0 row. Table didn't create!", Integer.valueOf(0));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), "Test System", targetTableTitle, "select sim from tdm_test_import_sql_source_table_new_empty_request where sim = '1'", Integer.valueOf(30));
        this.deleteTestDataTableIfExists("tdm_test_import_sql_source_table_new_empty_request");
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_importSqlTestDataWrongEnvironment_returnErrorMessage() {
        Mockito.when((Object)this.environmentsService.getEnvNameById((UUID)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        String error = String.format("Environment: [%s] was not found.", environmentId);
        ImportTestDataStatistic statistic = new ImportTestDataStatistic(environmentId.toString(), error, Integer.valueOf(0));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), "Test System", "TDM Test import sql wrong table", "select column from table", Integer.valueOf(30));
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_importSqlTestDataWrongSystem_returnErrorMessage() {
        String systemName = "Wrong Test System";
        Mockito.when((Object)this.environmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        String error = String.format("System with name[%s] for environment[%s] was not found.", systemName, environmentId);
        ImportTestDataStatistic statistic = new ImportTestDataStatistic("Test Environment", error, Integer.valueOf(0));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), systemName, "TDM Test import sql wrong table", "select column from table", Integer.valueOf(30));
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_importSqlTestDataWrongConnection_returnErrorMessage() {
        Mockito.when((Object)this.environmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)systemErrorConnectionName);
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        String error = String.format("Connection with name [%s] was not found.", "DB");
        ImportTestDataStatistic statistic = new ImportTestDataStatistic("Test Environment", error, Integer.valueOf(0));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), "Test System", "TDM Test import sql wrong table", "select column from table", Integer.valueOf(30));
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_importSqlTestDataWrongCredentials_returnErrorMessage() {
        Mockito.when((Object)this.environmentsService.getFullSystemByName((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)systemErrorCredentials);
        ArrayList<ImportTestDataStatistic> expectedStatistic = new ArrayList<ImportTestDataStatistic>();
        ImportTestDataStatistic statistic = new ImportTestDataStatistic("Test Environment", "Error access DB of system.", Integer.valueOf(0));
        expectedStatistic.add(statistic);
        List actualStatistics = this.testDataService.importSqlTestData(projectId, Collections.singletonList(environmentId), "Test System", "TDM Test import sql wrong table", "select column from table", Integer.valueOf(30));
        Assertions.assertEquals(expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_getTableEnvironments_returnNormalMultipleEnvsList() {
        UUID firstEnvironmentId = UUID.randomUUID();
        UUID secondEnvironmentId = UUID.randomUUID();
        String targetTableTitle = "TDM Test environments table";
        String firstTargetTableName = "tdm_test_first_environments_table";
        String secondTargetTableName = "tdm_test_second_environments_table";
        this.createTestDataTableCatalog(projectId, systemId, firstEnvironmentId, targetTableTitle, firstTargetTableName);
        this.createTestDataTableCatalog(projectId, systemId, secondEnvironmentId, targetTableTitle, secondTargetTableName);
        ArrayList<UUID> environmentIds = new ArrayList<UUID>();
        environmentIds.add(firstEnvironmentId);
        environmentIds.add(secondEnvironmentId);
        EnvsList expectedEnvsList = new EnvsList(environmentIds);
        Collections.sort(expectedEnvsList.getItems());
        EnvsList actualEnvsList = this.testDataService.getTableEnvironments(projectId, targetTableTitle);
        Collections.sort(actualEnvsList.getItems());
        this.catalogRepository.deleteByTableName("tdm_test_first_environments_table");
        this.catalogRepository.deleteByTableName("tdm_test_second_environments_table");
        Assertions.assertEquals((int)expectedEnvsList.getItems().size(), (int)actualEnvsList.getItems().size());
        Assertions.assertTrue((boolean)actualEnvsList.getItems().equals(expectedEnvsList.getItems()));
    }

    @Test
    public void testDataService_getTableEnvironments_returnEmptyEnvsList() {
        String targetTableTitle = "TDM Test environments table";
        EnvsList actualEnvsList = this.testDataService.getTableEnvironments(projectId, targetTableTitle);
        Assertions.assertEquals((int)0, (int)actualEnvsList.getItems().size());
    }

    @Test
    public void testDataService_getTableRow_successfulResult() {
        String tableName = "tdm_test_get_test_data_row";
        String tableTitle = "TDM Test row table";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        Map<String, Object> expectedRow = this.createTestDataTableRow(tableName);
        Map actualRow = this.testDataService.getTableRow(projectId, systemId, tableTitle, "sim", "8901260720040140811", false);
        this.deleteTestDataTableIfExists(tableName);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals(expectedRow, (Object)actualRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataService_getTableRow_failResultWrongColumnName() {
        String tableName = "tdm_test_get_test_data_row_wrong_column_name";
        String tableTitle = "TDM Test row table wrong column name";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        try {
            this.testDataService.getTableRow(projectId, systemId, tableTitle, "test", "8901260720040140811", false);
        }
        catch (RuntimeException re) {
            String message = String.format("Error while retrieving test data from table [%s] under project [%s] and system [%s].", tableTitle, projectId, systemId);
            Assertions.assertEquals((Object)message, (Object)re.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataService_getTableRow_failResultWrongProject() {
        String tableName = "tdm_test_get_test_data_wrong_project";
        String tableTitle = "TDM Test row table wrong project";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        UUID tempProjectId = UUID.randomUUID();
        try {
            this.testDataService.getTableRow(tempProjectId, systemId, tableTitle, "sim", "8901260720040140811", false);
        }
        catch (RuntimeException re) {
            String message = String.format("Table [%s] under project [%s] and system [%s] wasn't found.", tableTitle, tempProjectId, systemId);
            Assertions.assertEquals((Object)message, (Object)re.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataService_getTableRow_failResultWrongTableTitle() {
        String tableName = "tdm_test_get_test_data_wrong_table_title";
        String tableTitle = "TDM Test row table wrong table title";
        String wrongTableTitle = "wrong_table_title";
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        try {
            this.testDataService.getTableRow(projectId, systemId, wrongTableTitle, "sim", "8901260720040140811", false);
        }
        catch (RuntimeException re) {
            String message = String.format("Table [%s] under project [%s] and system [%s] wasn't found.", wrongTableTitle, projectId, systemId);
            Assertions.assertEquals((Object)message, (Object)re.getMessage());
        }
        finally {
            this.deleteTestDataTableIfExists(tableName);
            this.catalogRepository.deleteByTableName(tableName);
        }
    }

    @Test
    public void testDataService_changeTestDataTitle_testDataTitleChanged() {
        String tableName = "tdm_test_change_test_data_title";
        String tableTitle = "TDM Test. Change Test Data Title";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, tableTitle, tableName);
        String newTableTitle = "TDM Test. Change Test Data Title. New Title";
        boolean updated = this.testDataService.changeTestDataTitle(tableName, newTableTitle);
        Assertions.assertTrue((boolean)updated);
        TestDataTableCatalog tableCatalog = this.testDataService.getTestDataTablesCatalog(projectId, systemId).stream().filter(t -> tableName.equals(t.getTableName())).findFirst().orElseGet(TestDataTableCatalog::new);
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)newTableTitle, (Object)tableCatalog.getTableTitle());
    }

    @Test
    public void testDataService_createTableBySql_updateBySql_rowsUpdatedAndStatisticReturned() {
        String tableName = "tdm_test_sql_update_sql_source_table";
        this.createTestDataTable(tableName);
        String targetTableTitle = "TDM Test create by sql update sql";
        String targetTableName = "tdm_test_create_by_sql_update_sql";
        String query = "select NAME, OBJECT_ID from nc_objects where rownum < 5";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName, query);
        this.createSmallTestDataTable(targetTableName);
        ImportTestDataStatistic expectedStatistic = new ImportTestDataStatistic("Test Environment", null, Integer.valueOf(6));
        ImportTestDataStatistic actualStatistics = this.testDataService.updateTestDataBySql(projectId, environmentId, systemId, targetTableName, "select sim, environment from tdm_test_sql_update_sql_source_table where sim = ${'SIM'}", Integer.valueOf(30));
        this.deleteTestDataTableIfExists(tableName);
        this.deleteTestDataTableIfExists(targetTableName);
        this.catalogRepository.deleteByTableName(targetTableName);
        Assertions.assertEquals((Object)expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_create_excel_updateBySql_rowsUpdatedAndStatisticReturned() {
        String tableName = "tdm_test_excel_update_sql_source_table";
        this.createTestDataTable(tableName);
        String targetTableTitle = "TDM Test create by excel update sql";
        String targetTableName = "tdm_test_create_by_excel_update_sql";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName);
        this.createSmallTestDataTable(targetTableName);
        ImportTestDataStatistic expectedStatistic = new ImportTestDataStatistic("Test Environment", null, Integer.valueOf(6));
        ImportTestDataStatistic actualStatistics = this.testDataService.updateTestDataBySql(projectId, environmentId, systemId, targetTableName, "select sim, environment from tdm_test_excel_update_sql_source_table where sim = ${'SIM'}", Integer.valueOf(30));
        this.deleteTestDataTableIfExists(tableName);
        this.deleteTestDataTableIfExists(targetTableName);
        this.catalogRepository.deleteByTableName(targetTableName);
        Assertions.assertEquals((Object)expectedStatistic, (Object)actualStatistics);
    }

    @Test
    public void testDataService_updateBySql_wrongColumnName() {
        String tableName = "tdm_test_excel_update_wrong_sql_source_table";
        this.createTestDataTable(tableName);
        String targetTableTitle = "TDM Test update sql";
        String targetTableName = "tdm_test_update_wrong_sql";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName);
        this.createSmallTestDataTable(targetTableName);
        ImportTestDataStatistic actualStatistics = this.testDataService.updateTestDataBySql(projectId, environmentId, systemId, targetTableName, "select sim, wrong_column from tdm_test_excel_update_wrong_sql_source_table where \"sim\"=${'SIM'}", Integer.valueOf(30));
        this.deleteTestDataTableIfExists(tableName);
        this.deleteTestDataTableIfExists(targetTableName);
        this.catalogRepository.deleteByTableName(targetTableName);
        Assertions.assertTrue((boolean)actualStatistics.getError().contains("Error while updating table: " + targetTableName));
    }

    @Test
    public void testDataService_updateBySql_wrongQuery() {
        String tableName = "tdm_test_excel_update_wrong_query_sql_source_table";
        this.createTestDataTable(tableName);
        String targetTableTitle = "TDM Test update sql";
        String targetTableName = "tdm_test_update_wrong_query_sql";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName);
        this.createSmallTestDataTable(targetTableName);
        ImportTestDataStatistic actualStatistics = this.testDataService.updateTestDataBySql(projectId, environmentId, systemId, targetTableName, "sElEsT sim from tdm_test_excel_update_wrong_query_sql_source_table where \"sim\"=${'SIM'}", Integer.valueOf(30));
        this.deleteTestDataTableIfExists(tableName);
        this.deleteTestDataTableIfExists(targetTableName);
        this.catalogRepository.deleteByTableName(targetTableName);
        Assertions.assertTrue((boolean)actualStatistics.getError().contains("Error while updating table: " + targetTableName));
    }

    @Test
    public void testDataService_createTableBySql_updateBySql_returnConnectionException() {
        Mockito.when((Object)this.environmentsService.getConnectionsSystemById((UUID)ArgumentMatchers.any())).thenReturn(Arrays.asList(dbConnectionErrorCredentials));
        String tableName = "tdm_test_sql_update_sql_source_table";
        this.createTestDataTable(tableName);
        String targetTableTitle = "TDM Test create by sql update sql";
        String targetTableName = "tdm_test_create_by_sql_update_sql";
        String query = "select NAME, OBJECT_ID from nc_objects where rownum < 5";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName, query);
        this.createSmallTestDataTable(targetTableName);
        String errorMessage = "Error while updating table: " + targetTableName + ". Can not create connection for";
        ImportTestDataStatistic actualStatistics = this.testDataService.updateTestDataBySql(projectId, environmentId, systemId, targetTableName, "select sim, environment from tdm_test_sql_update_sql_source_table where sim = ${'SIM'}", Integer.valueOf(30));
        this.deleteTestDataTableIfExists(tableName);
        this.deleteTestDataTableIfExists(targetTableName);
        this.catalogRepository.deleteByTableName(targetTableName);
        Assertions.assertTrue((boolean)actualStatistics.getError().contains(errorMessage));
    }

    @Test
    public void testDataService_getDistinctColumns_returnDistinctList() {
        UUID system2 = UUID.randomUUID();
        UUID project2 = UUID.randomUUID();
        String tableName = "distinctTableName_" + System.currentTimeMillis();
        String tableTitle = "distinctTableTitle";
        ArrayList<String> expectedColumnsList = new ArrayList<String>(Arrays.asList("8901260720040140811", "8901260720040140822", "8901260720040140973", "8901260720040141084", "8901260720040140975", "8901260720040141106"));
        this.createTestDataTable(tableName);
        this.createTestDataTableCatalog(project2, system2, environmentId, tableTitle, tableName);
        List actualResult = this.testDataService.getDistinctTablesColumnValues(system2, environmentId, "sim");
        Assertions.assertTrue((expectedColumnsList.containsAll(((TableColumnValues)actualResult.get(0)).getValues()) && ((TableColumnValues)actualResult.get(0)).getValues().containsAll(expectedColumnsList) ? 1 : 0) != 0);
        Assertions.assertEquals((Object)tableName.toLowerCase(), (Object)((TableColumnValues)actualResult.get(0)).getTableName());
        Assertions.assertEquals((Object)tableTitle, (Object)((TableColumnValues)actualResult.get(0)).getTableTitle());
    }

    @Test
    public void testDataService_getLinkWhereFullValueStoredIntoTableCell_returnFirstValueFromTableCell() {
        UUID projectId = UUID.randomUUID();
        UUID systemId = UUID.randomUUID();
        this.createTestDataTable("tdm_test_get_full_link_from_table_cell");
        String targetTableTitle = "TDM get full link from table cell";
        String targetTableName = "tdm_get_full_link_from_table_cell";
        this.createTestDataTableCatalog(projectId, systemId, environmentId, targetTableTitle, targetTableName);
        this.createSmallTestDataTable(targetTableName);
        String actualLink = this.testDataService.getPreviewLink(projectId, systemId, "endpoit", "Assignment", targetTableName, Boolean.valueOf(true));
        this.deleteTestDataTableIfExists("tdm_test_get_full_link_from_table_cell");
        this.deleteTestDataTableIfExists("tdm_get_full_link_from_table_cell");
        this.catalogRepository.deleteByTableName("tdm_get_full_link_from_table_cell");
        Assertions.assertEquals((Object)actualLink, (Object)"51");
    }
}

