/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import java.time.LocalDate;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.utils.DataUtils;
import org.qubership.atp.tdm.utils.TestDataTableConvertor;

public class DataUtilsTest
extends AbstractTestDataTest {
    private static final UUID projectId = UUID.randomUUID();
    private static final String SELECT_FOR_COMPARISION = "SELECT * FROM %s WHERE \"CREATED_WHEN\" >= TIMESTAMP '%s 23:59:59' AND \"ROW_ID\" = ${'ROW_ID'}::UUID";

    @AfterEach
    public void after() {
        this.catalogRepository.deleteByTableName("tdm_prepare_cleanup_config");
        this.deleteTestDataTableIfExists("tdm_prepare_cleanup_config");
    }

    @Test
    public void queryUtils_prepareCleanupByDateQuery_normalQuery() throws Exception {
        String tableName = "tdm_prepare_cleanup_config";
        TestDataTableCatalog table = this.createTestDataTableCatalog(projectId, systemId, environmentId, "TDM Prepare Cleanup Config", tableName);
        TestDataCleanupConfig testDataDateCleanupConfig = this.createDateCleanupConfig(table);
        LocalDate expectedQuery = LocalDate.now().minusWeeks(3L).minusDays(4L);
        LocalDate actualQuery = DataUtils.calculateExpiredData((String)testDataDateCleanupConfig.getSearchDate());
        this.catalogRepository.deleteByTableName(tableName);
        Assertions.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    @Test
    public void dataUtils_checkTableName_success() {
        String tableNameGenerate = TestDataTableConvertor.generateTestDataTableName();
        String tableName = "tdm_api_test_check_table_name";
        DataUtils.checkTableName((String)tableNameGenerate);
        DataUtils.checkTableName((String)tableName);
    }

    @Test
    public void dataUtils_checkTableName_error() {
        String tableName = "tdm_api_test_check table_name";
        try {
            DataUtils.checkTableName((String)tableName);
        }
        catch (Exception e) {
            String message = String.format("Table name: %s, does not match pattern.", tableName);
            Assertions.assertEquals((Object)message, (Object)e.getMessage());
        }
    }

    @Test
    public void dataUtils_checkColumnName_success() {
        String columnName = "ROW_ID";
        DataUtils.checkColumnName((String)columnName);
    }

    @Test
    public void dataUtils_checkColumnName_error() {
        String columnName = "ROW_ID\"";
        try {
            DataUtils.checkColumnName((String)columnName);
        }
        catch (Exception e) {
            String message = String.format("Parameter [%s] must not contain the symbol: \"", columnName);
            Assertions.assertEquals((Object)message, (Object)e.getMessage());
        }
    }

    @Test
    public void dataUtils_checkQ_success() {
        String query = "select row_id from catalog;";
        DataUtils.checkQuery((String)query);
    }

    @Test
    public void dataUtils_checkQ_error() {
        String query = "select row_id from catalog; drop catalog";
        try {
            DataUtils.checkQuery((String)query);
        }
        catch (Exception e) {
            String message = "The request contains prohibited keyword";
            Assertions.assertEquals((Object)message, (Object)e.getMessage());
        }
    }
}

