/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.tdm.AbstractTestDataTest;
import org.qubership.atp.tdm.utils.QueryEvaluator;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryEvaluatorTest
extends AbstractTestDataTest {
    @Autowired
    private QueryEvaluator queryEvaluator;

    @AfterEach
    public void after() {
        this.deleteTestDataTableIfExists("query_evaluator_table");
    }

    @Test
    public void queryEvaluator_evaluateQueryWithMacrosses_macrossesSuccessfullyReplaced() {
        String tableName = "query_evaluator_table";
        this.createTestDataTable(tableName);
        String query = "select name, object_id, object_type_id \nfrom nc_objects \nwhere OBJECT_ID not in (${select \"sim\" from tdm_table where \"SELECTED\" = false}) \nand not object_type_id in (${select \"Operator ID\" from tdm_table})\nand rownum < 3";
        String expectedQuery = "select name, object_id, object_type_id \nfrom nc_objects \nwhere OBJECT_ID not in (8901260720040140811, 8901260720040140822, 8901260720040140973, 8901260720040141084, 8901260720040140975, 8901260720040141106) \nand not object_type_id in (2501, 2502, 2503, 2504, 2505, 2506)\nand rownum < 3";
        String actualQuery = this.queryEvaluator.evaluate(tableName, query);
        Assertions.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }
}

