/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.tdm.controllers.api.dto.refresh.RefreshResultsDto;
import org.qubership.atp.tdm.controllers.api.dto.refresh.TestDataRefreshConfigDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="DataRefreshController", description="Data Refresh Controller")
public interface DataRefreshControllerApi {
    @Operation(operationId="getNextScheduledRun", summary="Get next run's date / time details.", tags={"data-refresh-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/data/refresh/next/run"}, produces={"application/json"})
    public ResponseEntity<String> getNextScheduledRun(@NotNull @Parameter(name="cronExpression", description="cronExpression", required=true) @Valid @RequestParam(value="cronExpression", required=true) String var1);

    @Operation(operationId="getRefreshConfig", summary="Get refresh configuration for specified dataset / table ID.", tags={"data-refresh-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataRefreshConfigDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tdm/data/refresh/config/{id}"}, produces={"application/json"})
    public ResponseEntity<TestDataRefreshConfigDto> getRefreshConfig(@Parameter(name="id", description="id", required=true) @PathVariable(value="id") UUID var1);

    @Operation(operationId="runDataRefresh", summary="Force run data refresh.", tags={"data-refresh-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RefreshResultsDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/data/refresh/run"}, produces={"application/json"})
    public ResponseEntity<List<RefreshResultsDto>> runDataRefresh(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @NotNull @Parameter(name="queryTimeout", description="queryTimeout", required=true) @Valid @RequestParam(value="queryTimeout", required=true) Integer var2, @NotNull @Parameter(name="allEnv", description="allEnv", required=true) @Valid @RequestParam(value="allEnv", required=true) Boolean var3);

    @Operation(operationId="saveRefreshConfig", summary="Save / update data refresh settings.", tags={"data-refresh-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestDataRefreshConfigDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/data/refresh/config"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestDataRefreshConfigDto> saveRefreshConfig(@NotNull @Parameter(name="tableName", description="tableName", required=true) @Valid @RequestParam(value="tableName", required=true) String var1, @NotNull @Parameter(name="queryTimeout", description="queryTimeout", required=true) @Valid @RequestParam(value="queryTimeout", required=true) Integer var2, @Parameter(name="TestDataRefreshConfigDto", description="") @Valid @RequestBody(required=false) TestDataRefreshConfigDto var3);
}

