/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchColumnException;
import org.qubership.atp.tdm.model.ColumnType;
import org.qubership.atp.tdm.model.FilterType;
import org.qubership.atp.tdm.model.LinkSetupResult;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.table.OrderType;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumnIdentity;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.ColumnRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.repo.impl.SystemColumns;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.utils.TestDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ColumnServiceImpl
implements ColumnService {
    private static final Logger log = LoggerFactory.getLogger(ColumnServiceImpl.class);
    private static final String CONNECTION_NAME = "HTTP";
    private static final String PARAMETER_NAME_URL = "url";
    private static final String PARAMETER_NAME_EXTERNAL_URL = "external_url";
    private static final int COUNT_OF_DISTINCT_VALUES_FOR_LIST_FILTER_TYPE = 10;
    private final CatalogRepository catalogRepository;
    private final ColumnRepository columnRepository;
    private final EnvironmentsService environmentsService;
    private final TestDataTableRepository testDataTableRepository;
    private final LockManager lockManager;
    @Value(value="${tdm.linker.property.external.url}")
    private Boolean externalUrl;

    @Lazy
    @Autowired
    public ColumnServiceImpl(@Nonnull CatalogRepository catalogRepository, @Nonnull ColumnRepository columnRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull TestDataTableRepository testDataTableRepository, @Nonnull LockManager lockManager) {
        this.catalogRepository = catalogRepository;
        this.columnRepository = columnRepository;
        this.environmentsService = environmentsService;
        this.testDataTableRepository = testDataTableRepository;
        this.lockManager = lockManager;
    }

    @Override
    public List<TestDataTableColumn> extractColumns(@Nonnull String tableName, @Nonnull TestDataType testDataType, @Nonnull ResultSet resultSet, @Nullable TestDataTableOrder testDataTableOrder) throws SQLException {
        List<TestDataTableColumn> columns = this.extractColumns(tableName, testDataType, resultSet);
        this.setColumnTypes(columns, tableName);
        this.setColumnOrder(columns, testDataTableOrder);
        return columns;
    }

    @Override
    public List<TestDataTableColumn> extractColumns(@Nonnull String tableName, @Nonnull TestDataType testDataType, @Nonnull ResultSet resultSet) throws SQLException {
        log.info("ExtractColumn start");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colCount = metaData.getColumnCount();
        ArrayList<TestDataTableColumn> columns = new ArrayList<TestDataTableColumn>();
        for (int c = 1; c <= colCount; ++c) {
            String columnName = metaData.getColumnName(c);
            String columnType = metaData.getColumnTypeName(c);
            TestDataTableColumn column = new TestDataTableColumn();
            column.setIdentity(new TestDataTableColumnIdentity(tableName, columnName));
            if (SystemColumns.CREATED_WHEN.getName().equalsIgnoreCase(columnName) || SystemColumns.OCCUPIED_DATE.getName().equalsIgnoreCase(columnName)) {
                column.setColumnType(ColumnType.DATE);
                column.setFilterType(FilterType.DATE);
            } else {
                boolean occupied = TestDataType.OCCUPIED.equals((Object)testDataType);
                log.debug("GetColumnDistinctValues start");
                int columnDistinctValuesCount = this.testDataTableRepository.getColumnDistinctValuesCount(tableName, columnName, columnType, occupied);
                log.debug("GetColumnDistinctValues finish");
                if (columnDistinctValuesCount < 1) {
                    column.setFilterType(FilterType.NONE);
                } else if (columnDistinctValuesCount < 10) {
                    column.setFilterType(FilterType.LIST);
                } else {
                    column.setFilterType(FilterType.TEXT);
                }
            }
            columns.add(column);
        }
        log.info("ExtractColumn finish");
        return columns;
    }

    @Override
    public List<TestDataTableColumn> extractColumnsMultiple(@Nonnull String tableName, @Nonnull TestDataType testDataType, @Nonnull ResultSet resultSet) throws SQLException {
        log.debug("extractColumnsMultiple start");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<TestDataTableColumn> columns = new ArrayList<TestDataTableColumn>();
        for (int columnIdx = 1; columnIdx <= resultSetMetaData.getColumnCount(); ++columnIdx) {
            String columnName = resultSetMetaData.getColumnName(columnIdx);
            TestDataTableColumn column = new TestDataTableColumn();
            column.setIdentity(new TestDataTableColumnIdentity(tableName, columnName));
            if (SystemColumns.CREATED_WHEN.getName().equalsIgnoreCase(columnName) || SystemColumns.OCCUPIED_DATE.getName().equalsIgnoreCase(columnName)) {
                column.setColumnType(ColumnType.DATE);
                column.setFilterType(FilterType.DATE);
            }
            columns.add(column);
        }
        log.debug("extractColumnsMultiple finish");
        return columns;
    }

    private void setColumnTypes(@Nonnull List<TestDataTableColumn> columns, @Nonnull String tableName) {
        List<TestDataTableColumn> columnsTypes = this.columnRepository.findAllByIdentityTableNameAndIdentityColumnNameIn(tableName, columns.stream().map(c -> c.getIdentity().getColumnName()).collect(Collectors.toList()));
        for (TestDataTableColumn linkColumn : columnsTypes) {
            String columnName = linkColumn.getIdentity().getColumnName();
            TestDataTableColumn column = columns.stream().filter(c -> columnName.equals(c.getIdentity().getColumnName())).findFirst().orElseGet(TestDataTableColumn::new);
            column.setColumnType(linkColumn.getColumnType());
            column.setColumnLink(linkColumn.getColumnLink());
        }
    }

    private void setColumnOrder(@Nonnull List<TestDataTableColumn> columns, @Nullable TestDataTableOrder order) {
        if (Objects.nonNull(order)) {
            columns.stream().filter(c -> c.getIdentity().getColumnName().equals(order.getColumnName())).findFirst().orElseThrow(() -> new TdmSearchColumnException(order.getColumnName())).setOrderType(order.getOrderType(OrderType.ASC));
        } else {
            this.setDefaultColumnOrder(columns);
        }
    }

    private void setDefaultColumnOrder(@Nonnull List<TestDataTableColumn> columns) {
        List<String> systemColumnNames = SystemColumns.getColumnNames();
        columns.stream().filter(c -> !systemColumnNames.contains(c.getIdentity().getColumnName())).forEach(c -> c.setOrderType(OrderType.TRUE));
    }

    @Override
    public String getColumnLink(@Nonnull UUID projectId, @Nonnull UUID systemId, @Nonnull String endpoint) {
        log.info("Getting link for project [{}], system [{}] with endpoint [{}]", new Object[]{projectId, systemId, endpoint});
        List connections = this.environmentsService.getConnectionsSystemById(systemId);
        Map parameters = TestDataUtils.getConnection(connections, CONNECTION_NAME).getParameters();
        String serverUrl = this.externalUrl != false ? this.getHttpUrlParamValue(parameters, PARAMETER_NAME_EXTERNAL_URL) : this.getHttpUrlParamValue(parameters, PARAMETER_NAME_URL);
        log.info("Got link for project [{}], system [{}] with endpoint [{}]", new Object[]{projectId, systemId, endpoint});
        return serverUrl + "/" + endpoint;
    }

    private String getHttpUrlParamValue(Map<String, String> parameters, String httpUrlParam) {
        if (!parameters.containsKey(httpUrlParam)) {
            throw new IllegalArgumentException(String.format("Parameter [%s] was not found.", httpUrlParam));
        }
        return parameters.get(httpUrlParam);
    }

    @Override
    public void setupColumnLinks(@Nonnull Boolean isAll, @Nonnull UUID projectId, @Nonnull UUID systemId, @Nonnull String tableName, @Nonnull String columnName, @Nonnull String endpoint, @Nonnull Boolean pickUpFullLinkFromTableCell) {
        if (isAll.booleanValue()) {
            this.setupColumnLinksForAllEnvTable(projectId, tableName, columnName, endpoint, pickUpFullLinkFromTableCell);
        } else {
            this.setupLinkForOneTable(projectId, systemId, tableName, columnName, endpoint, false, pickUpFullLinkFromTableCell);
        }
    }

    @Override
    public LinkSetupResult setUpLinks(@Nonnull UUID projectId, @Nonnull UUID systemId, @Nonnull String tableName) {
        log.info("Link refresh.");
        ArrayList columnNames = new ArrayList();
        this.lockManager.executeWithLockWithUniqueLockKey("set links " + tableName, () -> {
            List<TestDataTableColumn> columns = this.columnRepository.findAllByIdentityTableName(tableName);
            columns.forEach(column -> {
                String endpoint = this.extractEndpointFromFullUrl(column.getColumnLink());
                boolean pickUpFullLinkFromTableCell = false;
                if (endpoint.equals("")) {
                    pickUpFullLinkFromTableCell = true;
                }
                String columnName = column.getIdentity().getColumnName();
                this.setupLinkForOneTable(projectId, systemId, tableName, columnName, endpoint, column.isBulkLink(), pickUpFullLinkFromTableCell);
                columnNames.add(columnName);
            });
        });
        log.info("Refreshed links for table: {}", (Object)tableName);
        return new LinkSetupResult(StringUtils.join(columnNames, (String)", "));
    }

    @Override
    public void setUpLinks(@Nonnull UUID projectId, @Nonnull UUID systemId, @Nonnull String tableTitle, @Nonnull String tableName) {
        log.info("Resolving links for new table with title: {}, project id: {}, system id {}.", new Object[]{tableTitle, projectId, systemId});
        Optional<TestDataTableCatalog> tableCatalog = this.catalogRepository.findFirstByProjectIdAndTableTitle(projectId, tableTitle);
        if (tableCatalog.isPresent()) {
            List<TestDataTableColumn> columns = this.columnRepository.findAllByIdentityTableName(tableCatalog.get().getTableName());
            columns.forEach(column -> {
                if (column.isBulkLink()) {
                    String endpoint = this.extractEndpointFromFullUrl(column.getColumnLink());
                    boolean pickUpFullLinkFromTableCell = false;
                    if (endpoint.equals("")) {
                        pickUpFullLinkFromTableCell = true;
                    }
                    String columnName = column.getIdentity().getColumnName();
                    this.setupLinkForOneTable(projectId, systemId, tableName, columnName, endpoint, true, pickUpFullLinkFromTableCell);
                }
            });
        }
        log.info("Links for table with title: {} successfully updated.", (Object)tableTitle);
    }

    @Override
    public List<TestDataTableCatalog> getAllTablesWithLinks(@Nonnull UUID projectId, @Nonnull UUID systemId) {
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndSystemId(projectId, systemId);
        return catalogList.stream().filter(catalog -> !this.columnRepository.findAllByIdentityTableName(catalog.getTableName()).isEmpty()).collect(Collectors.toList());
    }

    @Override
    public List<TestDataTableColumn> getDistinctTableNames() {
        return this.columnRepository.findDistinctByIdentityTableName();
    }

    @Override
    public List<TestDataTableColumn> getAllColumnsByTableName(@Nonnull String tableName) {
        return this.columnRepository.findAllByIdentityTableName(tableName);
    }

    private String extractEndpointFromFullUrl(@Nonnull String url) {
        int endpointArrayIndex = 3;
        int lastHostSlashPosition = 4;
        if ("".equals(url)) {
            return "";
        }
        String[] endpointArray = url.split("/", lastHostSlashPosition);
        return endpointArray[endpointArrayIndex];
    }

    private void setupLinkForOneTable(@Nullable UUID projectId, @Nullable UUID systemId, @Nonnull String tableName, @Nonnull String columnName, @Nullable String endpoint, @Nonnull Boolean isAll, @Nonnull Boolean pickUpFullLinkFromTableCell) {
        log.info("Setting links up.");
        TestDataTableColumn column = new TestDataTableColumn();
        column.setColumnType(ColumnType.LINK);
        if (pickUpFullLinkFromTableCell.booleanValue()) {
            column.setColumnLink("");
        } else {
            column.setColumnLink(this.getColumnLink(projectId, systemId, endpoint));
        }
        column.setIdentity(new TestDataTableColumnIdentity(tableName, columnName));
        column.setBulkLink(isAll);
        this.columnRepository.save(column);
        log.info("Set up links for table: {}", (Object)tableName);
    }

    private void setupColumnLinksForAllEnvTable(@Nonnull UUID projectId, @Nonnull String tableName, @Nonnull String columnName, @Nonnull String endpoint, @Nonnull Boolean pickUpFullLinkFromTableCell) {
        log.info("Setting bulk links");
        TestDataTableCatalog catalog = this.catalogRepository.findTableByProjectIdAndTableName(projectId, tableName);
        List systems = this.environmentsService.getLazySystems(catalog.getEnvironmentId());
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndTableTitle(projectId, catalog.getTableTitle());
        catalogList.stream().filter(element -> Objects.nonNull(element.getSystemId())).filter(item -> systems.stream().anyMatch(s -> item.getSystemId().equals(s.getId()))).forEach(catalogItem -> this.setupLinkForOneTable(projectId, catalogItem.getSystemId(), catalogItem.getTableName(), columnName, endpoint, true, pickUpFullLinkFromTableCell));
        log.info("Setup bulk links for all tables with title [{}] under project [{}]", (Object)tableName, (Object)projectId);
    }

    @Override
    public void deleteByTableName(@NotNull String tableName) {
        log.info("Delete rows by table name {} in ColumnRepository", (Object)tableName);
        this.columnRepository.deleteByIdentity_TableName(tableName);
        log.info("Rows was deleted by table name {}.", (Object)tableName);
    }
}

