/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.mailsender;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.qubership.atp.integration.configuration.service.MailSenderService;
import org.qubership.atp.tdm.env.configurator.model.LazyProject;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.model.statistics.TestDataTableMonitoring;
import org.qubership.atp.tdm.model.statistics.report.StatisticsReportObject;
import org.qubership.atp.tdm.service.StatisticsService;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class StatisticsMailSender {
    private static final Logger log = LoggerFactory.getLogger(StatisticsMailSender.class);
    @Value(value="${mail.sender.enable:true}")
    private boolean mailSenderEnable;
    private final String mailSenderFrom;
    private final Configuration configuration;
    private final StatisticsService statisticsService;
    private final MailSenderService mailSender;
    private final MetricService metricService;
    private final String mailSenderSubject;
    private final EnvironmentsService environmentsService;
    private final String mailSenderTemplate;
    private final String mailSenderPath;

    @Autowired
    private StatisticsMailSender(@Value(value="${mail.sender.from}") String mailSenderFrom, @Nonnull Configuration configuration, @Nonnull StatisticsService statisticsService, @Nonnull MailSenderService mailSender, @Nonnull MetricService metricService, @Nonnull EnvironmentsService environmentsService, @Value(value="${mail.sender.statistics.subject}") String mailSenderSubject, @Value(value="${mail.sender.statistics.template}") String mailSenderTemplate, @Value(value="${mail.sender.statistics.path}") String mailSenderPath) {
        this.mailSenderFrom = mailSenderFrom;
        this.configuration = configuration;
        this.statisticsService = statisticsService;
        this.mailSender = mailSender;
        this.metricService = metricService;
        this.mailSenderSubject = mailSenderSubject;
        this.mailSenderTemplate = mailSenderTemplate;
        this.mailSenderPath = mailSenderPath;
        this.environmentsService = environmentsService;
    }

    public void send(String projectId) {
        if (this.mailSenderEnable) {
            this.metricService.executeStatisticsJob(projectId);
            TestDataTableMonitoring monitoring = this.statisticsService.getMonitoringSchedule(UUID.fromString(projectId));
            MailRequest mailRequest = new MailRequest();
            mailRequest.setFrom(this.mailSenderFrom);
            mailRequest.setTo(monitoring.getRecipients());
            try {
                UUID projId = UUID.fromString(projectId);
                StatisticsReportObject statisticsReportObject = this.statisticsService.getTestDataMonitoringStatistics(projId, monitoring.getThreshold());
                mailRequest.setSubject(String.format(this.mailSenderSubject, statisticsReportObject.getProjectName()));
                mailRequest.setContent(this.buildMessageContent(this.configuration, statisticsReportObject));
                HashMap<String, UUID> metadata = new HashMap<String, UUID>();
                metadata.put("projectId", projId);
                mailRequest.setMetadata(metadata);
                this.mailSender.send(mailRequest);
            }
            catch (Exception e) {
                String projectName = projectId;
                try {
                    LazyProject lazyProjectById = this.environmentsService.getLazyProjectById(UUID.fromString(projectId));
                    projectName = lazyProjectById.getName();
                }
                catch (Exception er) {
                    log.error(String.format("Error while get project by id: %s", projectId));
                }
                mailRequest.setSubject(String.format(this.mailSenderSubject, projectName));
                String messageError = "Error statistics send mail. Message: " + e.getMessage();
                mailRequest.setContent(messageError);
                this.mailSender.send(mailRequest);
                throw e;
            }
        }
    }

    private String buildMessageContent(Configuration freemarkerConfig, final StatisticsReportObject messageContent) {
        try {
            freemarkerConfig.setDirectoryForTemplateLoading(new File(this.mailSenderPath));
            Template template = freemarkerConfig.getTemplate(this.mailSenderTemplate);
            StringWriter writer = new StringWriter();
            template.process((Object)new HashMap<String, Object>(){
                {
                    this.put("downToThreshold", messageContent.getDownToThreshold());
                    this.put("upToThreshold", messageContent.getUpToThreshold());
                }
            }, (Writer)writer);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
        catch (TemplateException | IOException bmc) {
            String errorMsg = "Error observed while building message content for Test Data monitoring.";
            log.error(errorMsg, bmc);
            return errorMsg;
        }
    }
}

