/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.notification.projects;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.exceptions.kafka.TdmKafkaListenerReadEventException;
import org.qubership.atp.tdm.exceptions.kafka.TdmKafkaListenerTypeEventException;
import org.qubership.atp.tdm.mdc.MdcField;
import org.qubership.atp.tdm.model.ProjectInformation;
import org.qubership.atp.tdm.service.ProjectInformationService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.notification.projects.ProjectEvent;
import org.qubership.atp.tdm.service.notification.projects.ProjectEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.kafka.annotation.KafkaListener;

public class ProjectEventKafkaListener
implements ProjectEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectEventKafkaListener.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TestDataService testDataService;
    private final ProjectInformationService projectInformationService;

    public ProjectEventKafkaListener(@Nonnull TestDataService testDataService, @Nonnull ProjectInformationService projectInformationService) {
        this.testDataService = testDataService;
        this.projectInformationService = projectInformationService;
    }

    @Override
    @KafkaListener(topics={"${kafka.project.topic:catalog_notification_topic}"})
    @CacheEvict(value={"projects"}, allEntries=true)
    public void listen(String event) {
        ProjectEvent projectEvent;
        MDC.clear();
        try {
            projectEvent = (ProjectEvent)this.objectMapper.readValue(event, ProjectEvent.class);
        }
        catch (IOException e) {
            log.error(String.format("Can't read event [ %s ]", event), (Throwable)e);
            throw new TdmKafkaListenerReadEventException(event);
        }
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectEvent.getProjectId());
        switch (projectEvent.getType()) {
            case CREATE: {
                log.info("Project '{}' was created", (Object)projectEvent.getProjectName());
                this.projectInformationService.saveProjectInformation(new ProjectInformation(projectEvent.getProjectId(), projectEvent.getTimeZone(), projectEvent.getDateFormat(), projectEvent.getTimeFormat(), projectEvent.getTdmTableExpirationTime()));
                break;
            }
            case UPDATE: {
                log.info("Project '{}' was updated", (Object)projectEvent.getProjectName());
                this.projectInformationService.saveProjectInformation(new ProjectInformation(projectEvent.getProjectId(), projectEvent.getTimeZone(), projectEvent.getDateFormat(), projectEvent.getTimeFormat(), projectEvent.getTdmTableExpirationTime()));
                break;
            }
            case DELETE: {
                log.info("Project '{}' was deleted from projects catalogue", (Object)projectEvent.getProjectName());
                this.testDataService.deleteProjectFromCatalogue(projectEvent.getProjectId());
                break;
            }
            default: {
                log.error(String.format("Unknown type of events: %s", projectEvent.getType().name()));
                throw new TdmKafkaListenerTypeEventException(projectEvent.getType().name());
            }
        }
    }
}

