/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.notification.systems;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.exceptions.kafka.TdmKafkaListenerReadEventException;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.notification.systems.SystemEvent;
import org.qubership.atp.tdm.service.notification.systems.SystemEventListener;
import org.qubership.atp.tdm.service.notification.systems.SystemEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.kafka.annotation.KafkaListener;

public class SystemsEventKafkaListener
implements SystemEventListener {
    private static final Logger log = LoggerFactory.getLogger(SystemsEventKafkaListener.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TestDataService testDataService;
    private final CatalogRepository catalogRepository;
    private final TdmMdcHelper tdmMdcHelper;

    public SystemsEventKafkaListener(@Nonnull TestDataService testDataService, @Nonnull CatalogRepository catalogRepository, TdmMdcHelper tdmMdcHelper) {
        this.testDataService = testDataService;
        this.catalogRepository = catalogRepository;
        this.tdmMdcHelper = tdmMdcHelper;
    }

    @Override
    @KafkaListener(topics={"${kafka.systems.topic}"})
    public void listen(String event) {
        SystemEvent systemEvent;
        MDC.clear();
        log.info("Kafka system event: {}", (Object)event);
        try {
            systemEvent = (SystemEvent)this.objectMapper.readValue(event, SystemEvent.class);
        }
        catch (IOException e) {
            log.error(String.format("Can't read event [ %s ]", event), (Throwable)e);
            throw new TdmKafkaListenerReadEventException(event);
        }
        this.tdmMdcHelper.putSystemEventFields(systemEvent);
        if (SystemEventType.DELETE.equals((Object)systemEvent.getEventType())) {
            log.info("System '{}' was deleted", (Object)systemEvent.getId());
            this.catalogRepository.findBySystemId(systemEvent.getId()).forEach(x -> this.testDataService.deleteTestData(x.getTableName()));
        }
    }
}

