/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.tdm.model.mail.charts.ChartSeries;
import org.qubership.atp.tdm.model.table.TableColumnValues;

public class AvailableStatisticUtils {
    private static final int CATEGORY_COEF = 20;
    private static final List<String> colors = new ArrayList<String>(Arrays.asList("#09A4F1", "#00BB5B", "#FFB02E", "#6F0AAA", "#CB0077", "#FFFD00", "#5FD2B5", "#0C5AA6", "#A64600", "#F26D93"));

    public static String getColorByIndex(int index) {
        return colors.get(index % colors.size());
    }

    public static String buildHighChartConfigurationBody(String pathToTemplate, List<String> categories, List<ChartSeries> chartSeriesList) {
        String jsonString;
        try {
            categories = categories.stream().map(string -> string.replace("\"", "\\\"")).collect(Collectors.toList());
            File file = new File(pathToTemplate);
            String canonical = file.getCanonicalPath();
            jsonString = StringUtils.join(Files.readAllLines(Paths.get(canonical, new String[0])), (String)"");
            jsonString = String.format(jsonString, categories.size() * 20 + 100, StringUtils.join(categories, (String)"\",\""), new Gson().toJson(chartSeriesList));
        }
        catch (IOException e) {
            throw new RuntimeException("Wrong highchart configuration: " + e.getMessage(), e);
        }
        return jsonString;
    }

    public static String availableDataQuery(TableColumnValues columnValues, String activeColumn) {
        return String.format("SELECT \"%s\", count(*) FROM %s WHERE \"SELECTED\" = false AND \"%s\" IN ('%s') GROUP BY \"%s\"", activeColumn, columnValues.getTableName(), activeColumn, String.join((CharSequence)"','", columnValues.getValues()), activeColumn);
    }
}

