/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.websocket.bulkaction.dataload;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.tdm.env.configurator.model.LazyEnvironment;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.bulkaction.BulkActionConfig;
import org.qubership.atp.tdm.model.bulkaction.BulkActionResult;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkCleanupMailSender;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.qubership.atp.tdm.websocket.bulkaction.dataload.AbstractBulkDataLoadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.socket.WebSocketSession;

public class BulkDataImportHandler
extends AbstractBulkDataLoadHandler {
    private static final Logger log = LoggerFactory.getLogger(BulkDataImportHandler.class);

    public BulkDataImportHandler(@Qualifier(value="websocket") ExecutorService executorService, @Nonnull CatalogRepository catalogRepository, @Nonnull EnvironmentsService environmentsService, @Nonnull BulkCleanupMailSender mailSender, @Nonnull DataRefreshService dataRefreshService, @Nonnull ImportInfoRepository importInfoRepository, @Nonnull CurrentTime currentTime, @Nonnull LockManager lockManager, @Nonnull TdmMdcHelper mdcHelper) {
        super(executorService, catalogRepository, importInfoRepository, environmentsService, mailSender, dataRefreshService, currentTime, lockManager, mdcHelper);
    }

    @Override
    public List<Future<BulkActionResult>> runBulkAction(@Nonnull WebSocketSession session, @Nonnull ExecutorService executor, @Nonnull List<LazyEnvironment> lazyEnvironments, @Nonnull BulkActionConfig config, long processId) {
        log.info("Bulk data import has been initiated, id: {}, config: {}", (Object)processId, (Object)config);
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndTableTitle(config.getProjectId(), config.getTableTitle());
        List<TestDataTableCatalog> catalogListWithImportInfo = catalogList.stream().filter(item -> Objects.nonNull(this.importInfoRepository.findByTableName(item.getTableName()))).filter(item -> lazyEnvironments.stream().anyMatch(e -> item.getEnvironmentId().equals(e.getId()))).collect(Collectors.toList());
        log.trace("Found: {} tables with title [{}].", (Object)catalogListWithImportInfo.size(), (Object)config.getTableTitle());
        return this.runBulkAction(executor, lazyEnvironments, catalogListWithImportInfo, config.isSaveOccupiedData());
    }
}

