/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.configuration;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkCleanupMailSender;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkDropMailSender;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkLinksRefreshMailSender;
import org.qubership.atp.tdm.model.mail.bulkaction.BulkRefreshMailSender;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.service.CleanupService;
import org.qubership.atp.tdm.service.ColumnService;
import org.qubership.atp.tdm.service.DataRefreshService;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.utils.CurrentTime;
import org.qubership.atp.tdm.websocket.bulkaction.cleanup.BulkDataCleanupHandler;
import org.qubership.atp.tdm.websocket.bulkaction.dataload.BulkDataImportHandler;
import org.qubership.atp.tdm.websocket.bulkaction.dataload.BulkDataRefreshHandler;
import org.qubership.atp.tdm.websocket.bulkaction.drop.BulkDataDropHandler;
import org.qubership.atp.tdm.websocket.bulkaction.links.BulkDataLinksRefreshHandler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
public class WebSocketHandlerConfig
implements WebSocketConfigurer {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final CatalogRepository catalogRepository;
    private final ImportInfoRepository importInfoRepository;
    private final DataRefreshService dataRefreshService;
    private final CleanupService cleanupService;
    private final EnvironmentsService environmentsService;
    private final TestDataService testDataService;
    private final ColumnService columnService;
    private final CleanupConfigRepository cleanupConfigRepository;
    private final BulkRefreshMailSender bulkRefreshMailSender;
    private final BulkCleanupMailSender bulkCleanupMailSender;
    private final BulkDropMailSender bulkDropMailSender;
    private final BulkLinksRefreshMailSender bulkLinksRefreshMailSender;
    private final CurrentTime currentTime;
    private final LockManager lockManager;
    private final TdmMdcHelper mdcHelper;

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)new BulkDataRefreshHandler(this.executorService, this.catalogRepository, this.importInfoRepository, this.dataRefreshService, this.environmentsService, this.bulkRefreshMailSender, this.currentTime, this.lockManager, this.mdcHelper), new String[]{"websocket/bulk/refresh"}).setAllowedOrigins(new String[]{"*"});
        registry.addHandler((WebSocketHandler)new BulkDataCleanupHandler(this.executorService, this.catalogRepository, this.environmentsService, this.cleanupService, this.cleanupConfigRepository, this.bulkCleanupMailSender, this.currentTime, this.lockManager, this.mdcHelper), new String[]{"websocket/bulk/cleanup"}).setAllowedOrigins(new String[]{"*"});
        registry.addHandler((WebSocketHandler)new BulkDataImportHandler(this.executorService, this.catalogRepository, this.environmentsService, this.bulkCleanupMailSender, this.dataRefreshService, this.importInfoRepository, this.currentTime, this.lockManager, this.mdcHelper), new String[]{"websocket/bulk/import"}).setAllowedOrigins(new String[]{"*"});
        registry.addHandler((WebSocketHandler)new BulkDataDropHandler(this.executorService, this.catalogRepository, this.environmentsService, this.testDataService, this.bulkDropMailSender, this.currentTime, this.lockManager, this.mdcHelper), new String[]{"websocket/bulk/drop"}).setAllowedOrigins(new String[]{"*"});
        registry.addHandler((WebSocketHandler)new BulkDataLinksRefreshHandler(this.executorService, this.catalogRepository, this.environmentsService, this.columnService, this.bulkLinksRefreshMailSender, this.currentTime, this.lockManager, this.mdcHelper), new String[]{"websocket/bulk/links"}).setAllowedOrigins(new String[]{"*"});
    }

    @Bean(destroyMethod="shutdown")
    @Qualifier(value="websocket")
    public ExecutorService executor() {
        return this.executorService;
    }

    public WebSocketHandlerConfig(CatalogRepository catalogRepository, ImportInfoRepository importInfoRepository, DataRefreshService dataRefreshService, CleanupService cleanupService, EnvironmentsService environmentsService, TestDataService testDataService, ColumnService columnService, CleanupConfigRepository cleanupConfigRepository, BulkRefreshMailSender bulkRefreshMailSender, BulkCleanupMailSender bulkCleanupMailSender, BulkDropMailSender bulkDropMailSender, BulkLinksRefreshMailSender bulkLinksRefreshMailSender, CurrentTime currentTime, LockManager lockManager, TdmMdcHelper mdcHelper) {
        this.catalogRepository = catalogRepository;
        this.importInfoRepository = importInfoRepository;
        this.dataRefreshService = dataRefreshService;
        this.cleanupService = cleanupService;
        this.environmentsService = environmentsService;
        this.testDataService = testDataService;
        this.columnService = columnService;
        this.cleanupConfigRepository = cleanupConfigRepository;
        this.bulkRefreshMailSender = bulkRefreshMailSender;
        this.bulkCleanupMailSender = bulkCleanupMailSender;
        this.bulkDropMailSender = bulkDropMailSender;
        this.bulkLinksRefreshMailSender = bulkLinksRefreshMailSender;
        this.currentTime = currentTime;
        this.lockManager = lockManager;
        this.mdcHelper = mdcHelper;
    }
}

