/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.qubership.atp.tdm.controllers.api.dto.actions.ResponseMessageDto;
import org.qubership.atp.tdm.controllers.api.dto.actions.RestApiRequestDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="AtpActionController", description="Atp Action Controller")
public interface AtpActionControllerApi {
    @Operation(operationId="addInfoToRow", summary="ATP Action. Add info to row in table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/add-info-to-row"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> addInfoToRow(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="getMultipleColumnTestData", summary="ATP Action. Get multiple column test data from table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/get-records"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> getMultipleColumnTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="getTestData", summary="ATP Action. Get test data from table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/get-record"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> getTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="insertTestData", summary="ATP Action. Insert records to table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/insert-records"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ResponseMessageDto> insertTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="occupyTestData", summary="ATP Action. Occupy test data in table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/occupy-records"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> occupyTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="occupyTestDataFullRow", summary="ATP Action. Occupy test data in table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/occupy-records-full-row"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> occupyTestDataFullRow(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="refreshTables", summary="ATP Action. Refresh tables by name.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/refresh-tables"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> refreshTables(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="releaseFullTestData", summary="ATP Action. Release test data in table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/release-records/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> releaseFullTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="releaseTestData", summary="ATP Action. Release test data in table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/release-records"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> releaseTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="runCleanupForTable", summary="ATP Action. Run cleanup for table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/run-cleanup-table"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> runCleanupForTable(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="truncateTable", summary="ATP Action. Truncate table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/truncate-table"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> truncateTable(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);

    @Operation(operationId="updateTestData", summary="ATP Action. Update test data in table.", tags={"atp-action-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResponseMessageDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tdm/rest/update-records"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ResponseMessageDto>> updateTestData(@Parameter(name="RestApiRequestDto", description="") @Valid @RequestBody(required=false) RestApiRequestDto var1);
}

