/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class MetricService {
    private MeterRegistry meterRegistry;
    private JdbcTemplate jdbcTemplate;
    private static final String EXECUTE_CLEANUP_BY_CRON = "atp_tdm_execute_cleanup_by_cron";
    private static final String EXECUTE_REFRESH_BY_CRON = "atp_tdm_execute_refresh_by_cron";
    private static final String EXECUTE_STATISTICS_BY_CRON = "atp_tdm_execute_statistics_by_cron";
    private static final String EXECUTE_STATISTICS_USER_BY_CRON = "atp_tdm_execute_user_statistics_by_cron";
    private static final String CLEANUP_ID = "cleanup_id";
    private static final String REFRESH_ID = "refresh_id";
    private static final String PROJECT_ID = "project_id";
    private static final String TABLE_TITLE = "table_title";
    private static final String TABLES_COUNT_PER_PROJECT = "atp_tdm_tables_count_per_project";
    private static final String TABLES_COUNT = "atp_tdm_tables_count";
    private static final String INSERT_ACTION = "atp_tdm_insert_action";
    private static final String OCCUPY_ACTION = "atp_tdm_occupy_action";
    private static final String RELEASE_ACTION = "atp_tdm_release_action";
    private static final String UPDATE_ACTION = "atp_tdm_update_action";
    private static final String DELETE_ACTION = "atp_tdm_delete_action";
    private static final String GET_ACTION = "atp_tdm_get_action";
    private static final String PROJECT_NOT_FOUND = "UNKNOWN";

    @Autowired
    public MetricService(MeterRegistry meterRegistry, @Nonnull JdbcTemplate jdbcTemplate) {
        this.meterRegistry = meterRegistry;
        this.jdbcTemplate = jdbcTemplate;
        this.registerTablesPerProject();
        this.registerTablesCount();
    }

    public void registerTablesPerProject() {
        String queryForProjectIds = "select DISTINCT project_id from test_data_table_catalog;";
        List projectIds = this.jdbcTemplate.queryForList(queryForProjectIds, UUID.class);
        projectIds.forEach(v -> Gauge.builder((String)TABLES_COUNT_PER_PROJECT, (Object)this, eos -> eos.getTableCountForProject((UUID)v)).tag(PROJECT_ID, String.valueOf(v)).register(this.meterRegistry));
    }

    public int getTableCountForProject(UUID projectId) {
        String query = String.format("select count(*) from test_data_table_catalog where project_id='%s';", projectId);
        return (Integer)this.jdbcTemplate.queryForObject(query, Integer.class);
    }

    public void registerTablesCount() {
        Gauge.builder((String)TABLES_COUNT, (Object)this, eos -> eos.getTablesCount()).register(this.meterRegistry);
    }

    private int getTablesCount() {
        return (Integer)this.jdbcTemplate.queryForObject("select count(*) from test_data_table_catalog;", Integer.class);
    }

    public void executeStatisticsJob(String project) {
        this.incrementMetricExecuteStatisticsJob(project);
    }

    private void incrementMetricExecuteStatisticsJob(String project) {
        this.meterRegistry.counter(EXECUTE_STATISTICS_BY_CRON, new String[]{PROJECT_ID, project}).increment();
    }

    public void executeStatisticsUserJob(String project) {
        this.incrementMetricExecuteStatisticsUserJob(project);
    }

    private void incrementMetricExecuteStatisticsUserJob(String project) {
        this.meterRegistry.counter(EXECUTE_STATISTICS_USER_BY_CRON, new String[]{PROJECT_ID, project}).increment();
    }

    public void executeRefreshJob(String refreshId, UUID projectId, String tableTitle) {
        this.incrementMetricExecuteRefreshJob(refreshId, this.getProjectIdOrDefault(projectId), tableTitle);
    }

    private void incrementMetricExecuteRefreshJob(String refreshId, String project, String tableTitle) {
        this.meterRegistry.counter(EXECUTE_REFRESH_BY_CRON, new String[]{PROJECT_ID, project, TABLE_TITLE, tableTitle, REFRESH_ID, refreshId}).increment();
    }

    public void executeCleanupJob(String cleanupId, UUID projectId, String tableTitle) {
        this.incrementMetricExecuteCleanupJob(cleanupId, this.getProjectIdOrDefault(projectId), tableTitle);
    }

    private void incrementMetricExecuteCleanupJob(String cleanupId, String project, String tableTitle) {
        this.meterRegistry.counter(EXECUTE_CLEANUP_BY_CRON, new String[]{PROJECT_ID, project, TABLE_TITLE, tableTitle, CLEANUP_ID, cleanupId}).increment();
    }

    public void incrementInsertAction(UUID projectId) {
        this.meterRegistry.counter(INSERT_ACTION, new String[]{PROJECT_ID, this.getProjectIdOrDefault(projectId)}).increment();
    }

    public void incrementOccupyAction(String projectId) {
        this.meterRegistry.counter(OCCUPY_ACTION, new String[]{PROJECT_ID, this.getProjectIdOrDefault(projectId)}).increment();
    }

    public void incrementReleaseAction(String projectId) {
        this.meterRegistry.counter(RELEASE_ACTION, new String[]{PROJECT_ID, this.getProjectIdOrDefault(projectId)}).increment();
    }

    public void incrementUpdateAction(String projectId) {
        this.meterRegistry.counter(UPDATE_ACTION, new String[]{PROJECT_ID, this.getProjectIdOrDefault(projectId)}).increment();
    }

    public void incrementDeleteAction(String projectId) {
        this.meterRegistry.counter(DELETE_ACTION, new String[]{PROJECT_ID, this.getProjectIdOrDefault(projectId)}).increment();
    }

    public void incrementGetAction(String projectId) {
        this.meterRegistry.counter(GET_ACTION, new String[]{PROJECT_ID, this.getProjectIdOrDefault(projectId)}).increment();
    }

    private String getProjectIdOrDefault(String projectId) {
        return StringUtils.isEmpty((String)projectId) ? PROJECT_NOT_FOUND : projectId;
    }

    private String getProjectIdOrDefault(UUID projectId) {
        return projectId == null ? PROJECT_NOT_FOUND : projectId.toString();
    }
}

