/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.eventbus.impl.AgeBatchingQueue;
import com.netflix.eventbus.spi.SubscriberConfigProvider;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

class SizeAndAgeBatchingQueue
extends AgeBatchingQueue {
    private final int batchSize;

    SizeAndAgeBatchingQueue(Method subscriber, SubscriberConfigProvider.SubscriberConfig subscribe, AtomicLong queueSizeCounter) {
        this(subscriber, subscribe, true, queueSizeCounter);
    }

    @VisibleForTesting
    SizeAndAgeBatchingQueue(Method subscriber, SubscriberConfigProvider.SubscriberConfig subscribe, boolean scheduleReaper, AtomicLong queueSizeCounter) {
        super(subscriber, subscribe, scheduleReaper, queueSizeCounter);
        this.batchSize = subscribe.getBatchSize();
    }

    @Override
    protected AgeBatchingQueue.AgeBatch createNewBatch(@Nullable SubscriberConfigProvider.SubscriberConfig subscribe) {
        return new AgeAndSizeBatch(null != subscribe ? subscribe.getBatchSize() : this.batchSize);
    }

    private class AgeAndSizeBatch
    extends AgeBatchingQueue.AgeBatch {
        private final int batchSize;
        private AtomicInteger currentBatchSize;

        protected AgeAndSizeBatch(int batchSize) {
            this.batchSize = batchSize;
            this.currentBatchSize = new AtomicInteger();
        }

        @Override
        protected boolean addEvent(Object event) {
            if (this.currentBatchSize.get() >= this.batchSize && !SizeAndAgeBatchingQueue.this.reapCurrentBatch("Batch size exceeded")) {
                return false;
            }
            if (super.addEvent(event)) {
                this.currentBatchSize.incrementAndGet();
                return true;
            }
            return false;
        }

        @Override
        protected void clear() {
            super.clear();
            this.currentBatchSize.set(0);
        }
    }
}

