/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.lock;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.qubership.atp.common.lock.exceptions.AtpLockRejectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.policy.TimeoutRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class LockManager {
    private static final Logger log = LoggerFactory.getLogger(LockManager.class);
    private final Integer defaultLockDurationSec;
    private final Integer retryTimeoutSec;
    private final Integer retryPaceSec;
    private DefaultLockingTaskExecutor defaultLockingTaskExecutor;
    private static final int MAX_KEY_SIZE = 99;

    public LockManager(Integer defaultLockDurationSec, Integer retryTimeoutSec, Integer retryPaceSec, LockProvider lockProvider) {
        this.defaultLockDurationSec = defaultLockDurationSec;
        this.retryTimeoutSec = retryTimeoutSec;
        this.retryPaceSec = retryPaceSec;
        this.defaultLockingTaskExecutor = new DefaultLockingTaskExecutor(lockProvider);
    }

    public <T> T executeWithLockNoWait(String lockKey, Callable<T> callable, Supplier<T> defaultOnReject) {
        log.debug("start executeWithLockNoWait(lockKey: {})", (Object)lockKey);
        return this.executeWithLockNoWait(lockKey, this.defaultLockDurationSec, callable, defaultOnReject);
    }

    public void executeWithLockNoWait(String lockKey, Runnable runnable) {
        log.debug("start executeWithLockNoWait(lockKey: {}, Runnable)", (Object)lockKey);
        this.executeWithLockNoWait(lockKey, this.defaultLockDurationSec, runnable);
    }

    public <T> T executeWithLockNoWait(String lockKey, Integer lockDuration, Callable<T> callable, Supplier<T> defaultOnReject) {
        log.debug("start executeWithLockNoWait(lockKey: {}, lockDuration: {})", (Object)lockKey, (Object)lockDuration);
        try {
            return this.executeWithLock(lockKey, lockDuration, callable);
        }
        catch (AtpLockRejectException e) {
            log.error("Cannot obtain lock by key {}. Lock duration {} sec.", (Object)lockKey, (Object)lockDuration);
            return defaultOnReject.get();
        }
    }

    public void executeWithLockNoWait(String lockKey, Integer lockDuration, Runnable runnable) {
        log.debug("start executeWithLockNoWait(lockKey: {}, lockDuration: {}, Runnable)", (Object)lockKey, (Object)lockDuration);
        try {
            this.executeWithLock(lockKey, lockDuration, runnable);
        }
        catch (AtpLockRejectException e) {
            log.error("Cannot obtain lock by key {}. Lock duration {} sec.", (Object)lockKey, (Object)lockDuration);
        }
    }

    public <T> T executeWithLock(String lockKey, Callable<T> callable, Supplier<T> defaultOnReject) {
        log.debug("start executeWithLock(lockKey: {})", (Object)lockKey);
        return this.executeWithLock(lockKey, this.defaultLockDurationSec, callable, defaultOnReject);
    }

    public void executeWithLock(String lockKey, Runnable runnable) {
        log.debug("start executeWithLock(lockKey: {}, Runnable)", (Object)lockKey);
        this.executeWithLock(lockKey, this.defaultLockDurationSec, runnable);
    }

    public <T> T executeWithLock(String lockKey, Integer lockDurationSec, Callable<T> callable, Supplier<T> defaultOnReject) {
        log.debug("start executeWithLock(lockKey: {}, lockDurationSec: {})", (Object)lockKey, (Object)lockDurationSec);
        try {
            return (T)this.getRetryTemplate().execute(retryContext -> this.executeWithLock(lockKey, lockDurationSec, callable));
        }
        catch (AtpLockRejectException e) {
            log.error("Cannot obtain lock by key {}. Lock duration {} sec. Returning default value.", new Object[]{lockKey, lockDurationSec, e});
            return defaultOnReject.get();
        }
    }

    public void executeWithLock(String lockKey, Integer lockDurationSec, Runnable runnable) {
        this.executeWithLock(lockKey, lockDurationSec, () -> {
            runnable.run();
            return null;
        }, () -> null);
    }

    private <T> T executeWithLock(String lockKey, Integer lockDuration, Callable<T> callable) {
        log.debug("start executeWithLock(lockKey: {}, lockDuration: {})", (Object)lockKey, (Object)lockDuration);
        Duration lockAtMostUntil = Duration.ofSeconds(lockDuration.intValue());
        Duration lockAtLeastFor = Duration.ZERO;
        LockConfiguration lockConfiguration = new LockConfiguration(lockKey, lockAtMostUntil, lockAtLeastFor);
        LockingTaskExecutor.TaskResult taskResult = this.defaultLockingTaskExecutor.executeWithLock(callable::call, lockConfiguration);
        log.debug("end executeWithLock(lockKey: {}, lockDuration: {}), taskResult.wasExecuted: {}", new Object[]{lockKey, lockDuration, taskResult.wasExecuted()});
        if (!taskResult.wasExecuted()) {
            log.debug("Cannot obtain lock by key '{}'", (Object)lockKey);
            throw new AtpLockRejectException("Cannot obtain lock by key " + lockKey);
        }
        return (T)taskResult.getResult();
    }

    public void executeWithLockWithUniqueLockKey(String lockKey, Runnable runnable) {
        String lockKeyWithTimeMills = lockKey + " " + System.currentTimeMillis();
        String preparedLockKey = lockKeyWithTimeMills.length() > 99 ? lockKeyWithTimeMills.substring(0, 99) : lockKeyWithTimeMills;
        log.debug("start executeWithLock(lockKey: {}, preparedLockKey: {} Runnable)", (Object)lockKey, (Object)preparedLockKey);
        this.executeWithLock(preparedLockKey, this.defaultLockDurationSec, runnable);
    }

    private RetryTemplate getRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setBackOffPolicy(this.getFixedBackOffPolicy());
        retryTemplate.setRetryPolicy(this.getRetryPolicy());
        return retryTemplate;
    }

    private RetryPolicy getRetryPolicy() {
        TimeoutRetryPolicy timeoutRetryPolicy = new TimeoutRetryPolicy();
        timeoutRetryPolicy.setTimeout(TimeUnit.SECONDS.toMillis(this.retryTimeoutSec.intValue()));
        SimpleRetryPolicy exceptionTypeRetryPolicy = new SimpleRetryPolicy(Integer.MAX_VALUE, Collections.singletonMap(AtpLockRejectException.class, true));
        CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy();
        compositeRetryPolicy.setPolicies(new RetryPolicy[]{timeoutRetryPolicy, exceptionTypeRetryPolicy});
        return compositeRetryPolicy;
    }

    private BackOffPolicy getFixedBackOffPolicy() {
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(TimeUnit.SECONDS.toMillis(this.retryPaceSec.intValue()));
        return fixedBackOffPolicy;
    }
}

