/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.lock.provider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;

public class InMemoryStorageAccessorAccessor
extends AbstractStorageAccessor {
    private final Map<String, LockConfiguration> storage = new ConcurrentHashMap<String, LockConfiguration>();

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        this.storage.put(lockConfiguration.getName(), lockConfiguration);
        return true;
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        LockConfiguration currentConfig = this.storage.get(lockConfiguration.getName());
        if (currentConfig == null || currentConfig.getLockAtMostUntil().isBefore(lockConfiguration.getLockAtMostUntil())) {
            this.storage.put(lockConfiguration.getName(), lockConfiguration);
            return true;
        }
        return false;
    }

    public void unlock(LockConfiguration lockConfiguration) {
        this.storage.remove(lockConfiguration.getName());
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        return false;
    }
}

