/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.powermock.PowerMockInternalException;
import org.powermock.configuration.Configuration;
import org.powermock.configuration.support.ConfigurationMapper;
import org.powermock.configuration.support.PropertiesLoader;
import org.powermock.configuration.support.ValueAliases;

class ConfigurationBuilder<T extends Configuration<?>> {
    private final Map<String, String> alias;
    private final Class<T> configurationType;

    static <C extends Configuration<?>> ConfigurationBuilder<C> createConfigurationFor(Class<C> configurationType) {
        return new ConfigurationBuilder<C>(configurationType);
    }

    private ConfigurationBuilder(Class<T> configurationType) {
        this.configurationType = configurationType;
        this.alias = new HashMap<String, String>();
    }

    ConfigurationBuilder<T> withValueAlias(String alias, String value) {
        this.alias.put(alias, value);
        return this;
    }

    T fromFile(String configurationLocation) {
        Properties properties = new PropertiesLoader().load(configurationLocation);
        return this.fromProperties(properties);
    }

    T fromProperties(Properties properties) {
        ConfigurationCreator configurationCreator = new ConfigurationCreator(this.alias);
        return configurationCreator.create(this.configurationType, properties);
    }

    private static class ConfigurationCreator {
        private final ValueAliases alias;

        private ConfigurationCreator(Map<String, String> alias) {
            this.alias = new ValueAliases(alias);
        }

        public <T extends Configuration> T create(Class<T> configurationClass, Properties properties) {
            try {
                Configuration configuration = (Configuration)configurationClass.newInstance();
                if (properties != null) {
                    this.mapConfiguration(configurationClass, configuration, properties);
                }
                return (T)configuration;
            }
            catch (Exception e) {
                throw new PowerMockInternalException(e);
            }
        }

        private <T extends Configuration> void mapConfiguration(Class<T> configurationClass, T configuration, Properties properties) {
            new ConfigurationMapper<T>(configurationClass, configuration, this.alias).map(properties);
        }
    }
}

