/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.bytebuddy;

import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.powermock.core.bytebuddy.PrimitiveBoxing;

public class Variable {
    private final TypeDescription typeDefinitions;
    private final int offset;

    public static Variable of(TypeDescription.Generic variableType, int offset) {
        return new Variable(variableType.asErasure(), offset);
    }

    private Variable(TypeDescription typeDefinitions, int offset) {
        this.typeDefinitions = typeDefinitions;
        this.offset = offset;
    }

    public static class VariableAccess {
        public static StackManipulation load(Variable variable) {
            return VariableAccess.load(variable, false);
        }

        public static StackManipulation load(Variable variable, boolean boxing) {
            TypeDescription typeDefinitions = variable.typeDefinitions;
            if (typeDefinitions.isPrimitive() && boxing) {
                return new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.of((TypeDefinition)typeDefinitions).loadFrom(variable.offset), PrimitiveBoxing.forPrimitive((TypeDefinition)typeDefinitions)});
            }
            return MethodVariableAccess.of((TypeDefinition)typeDefinitions).loadFrom(variable.offset);
        }

        public static StackManipulation store(Variable variable) {
            return MethodVariableAccess.of((TypeDefinition)variable.typeDefinitions).storeAt(variable.offset);
        }
    }
}

