/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.controllers;

import java.util.List;
import java.util.Vector;
import org.qubership.atp.ei.ntt.controllers.TreeNodeFactory;
import org.qubership.atp.ei.ntt.controllers.TreeNodeFactoryDetector;
import org.qubership.atp.ei.ntt.controllers.impl.DefaultTreeNodeFactory;
import org.qubership.atp.ei.ntt.controllers.impl.DefaultTreeNodeFactoryDetector;
import org.qubership.atp.ei.ntt.model.TreeNode;

public abstract class AbstractTreeNodeController {
    public static final TreeNodeFactory DEFAULT_FACTORY = DefaultTreeNodeFactory.INSTANCE;
    private TreeNodeFactoryDetector factoryDetector = new DefaultTreeNodeFactoryDetector();

    public void clear(TreeNode item, Object ... helpArgs) {
        this.remove(item.getChildren().toArray(new TreeNode[item.getChildren().size()]), helpArgs);
    }

    public void remove(TreeNode[] item, Object ... helpArgs) {
        TreeNode parent;
        if (item.length > 0 && (parent = item[0].getParent()) != null) {
            List childs = parent.getChildren();
            Vector<Integer> itemsForRemove = new Vector<Integer>(1, 1);
            for (int i = 0; i < item.length; ++i) {
                int index = childs.indexOf(item[i]);
                if (index == -1) continue;
                itemsForRemove.add(index);
            }
            int offset = 0;
            int[] removedItems = new int[itemsForRemove.size()];
            for (Integer index : itemsForRemove) {
                childs.remove(index - offset);
                removedItems[offset] = index;
                ++offset;
            }
        }
    }

    public <T extends TreeNode> T create(Class<T> clazz, String name, Object ... helpArgs) {
        return this.factoryDetect(clazz, name, helpArgs).create(clazz, name, helpArgs);
    }

    protected TreeNodeFactory factoryDetect(Class<? extends TreeNode> clazz, String by, Object ... helpArgs) {
        TreeNodeFactory factory = this.getFactoryDetector().detect(clazz, by, helpArgs);
        if (factory == null) {
            factory = AbstractTreeNodeController.getDefaultFactory();
        }
        return factory;
    }

    public static TreeNodeFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public TreeNodeFactoryDetector getFactoryDetector() {
        return this.factoryDetector;
    }

    public void add(TreeNode parent, TreeNode[] child, Object ... helpArgs) {
        int offset = helpArgs != null && helpArgs.length > 0 && helpArgs[0] instanceof Integer ? ((Integer)helpArgs[0]).intValue() : parent.getChildren().size();
        int[] indices = new int[child.length];
        for (int i = 0; i < child.length; ++i) {
            int index = offset + i;
            parent.getChildren().add(index, child[i]);
            child[i].setParent(parent);
            indices[i] = index;
        }
    }
}

