/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.config;

import brave.Tracer;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;

public class Oauth2FeignClientInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(Oauth2FeignClientInterceptor.class);
    private final AccessTokenProvider accessTokenProvider;
    private final OAuth2ProtectedResourceDetails protectedResourceDetails;
    private final Tracer tracer;
    private final AccessTokenRequest accessTokenRequest;
    @Value(value="${atp-auth.refreshTimeBeforeExpirationInSec:300}")
    private Integer refreshTimeBeforeExpiration;

    public Oauth2FeignClientInterceptor(AccessTokenProvider accessTokenProvider, OAuth2ProtectedResourceDetails protectedResourceDetails, Tracer tracer) {
        this(accessTokenProvider, protectedResourceDetails, tracer, (AccessTokenRequest)new DefaultAccessTokenRequest());
    }

    public Oauth2FeignClientInterceptor(AccessTokenProvider accessTokenProvider, OAuth2ProtectedResourceDetails protectedResourceDetails, Tracer tracer, AccessTokenRequest accessTokenRequest) {
        this.accessTokenProvider = accessTokenProvider;
        this.protectedResourceDetails = protectedResourceDetails;
        this.tracer = tracer;
        this.accessTokenRequest = accessTokenRequest;
    }

    public void apply(RequestTemplate requestTemplate) {
        log.debug("start apply [requestTemplate.path={}]", (Object)requestTemplate.path());
    }

    public void setAuthorizationHeader(RequestTemplate requestTemplate, String token) {
        requestTemplate.header("Authorization", new String[]{String.format("%s %s", "Bearer", token)});
        Collection authorizationHeaderValues = (Collection)requestTemplate.headers().get("Authorization");
        boolean authorizationHeaderHasToken = authorizationHeaderValues.stream().anyMatch(value -> value.startsWith("Bearer".toLowerCase()));
        if (authorizationHeaderValues.size() > 1 && authorizationHeaderHasToken) {
            authorizationHeaderValues = authorizationHeaderValues.stream().filter(value -> !value.startsWith("Bearer".toLowerCase())).collect(Collectors.toList());
            requestTemplate.removeHeader("Authorization");
            requestTemplate.header("Authorization", (Iterable)authorizationHeaderValues);
        }
    }
}

