/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.builder.ReferenceMapExpression;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.PropertyReferenceCollector;
import org.modelmapper.internal.ProxyFactory;
import org.modelmapper.internal.TypeMapImpl;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.spi.DestinationSetter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.SourceGetter;

class ReferenceMapExpressionImpl<S, D>
implements ReferenceMapExpression<S, D> {
    private final TypeMapImpl<S, D> typeMap;
    private final ExplicitMappingBuilder.MappingOptions options;
    private final PropertyReferenceCollector collector;
    private final S source;
    private final D destination;

    ReferenceMapExpressionImpl(TypeMapImpl<S, D> typeMap) {
        this(typeMap, new ExplicitMappingBuilder.MappingOptions());
    }

    ReferenceMapExpressionImpl(TypeMapImpl<S, D> typeMap, ExplicitMappingBuilder.MappingOptions options) {
        this.typeMap = typeMap;
        this.options = options;
        this.collector = new PropertyReferenceCollector(typeMap.configuration, options);
        try {
            this.source = ProxyFactory.proxyFor(typeMap.getSourceType(), this.collector.newSourceInterceptor(), this.collector.getProxyErrors());
            this.destination = ProxyFactory.proxyFor(typeMap.getDestinationType(), this.collector.newDestinationInterceptor(), this.collector.getProxyErrors());
        }
        catch (ErrorsException e) {
            throw e.getErrors().toConfigurationException();
        }
    }

    @Override
    public <V> void map(SourceGetter<S> sourceGetter, DestinationSetter<D, V> destinationSetter) {
        this.visitSource(sourceGetter);
        this.visitDestination(destinationSetter);
        this.skipMapping(this.collector.collect());
        this.collector.reset();
    }

    @Override
    public <V> void skip(DestinationSetter<D, V> destinationSetter) {
        this.options.skipType = 1;
        this.visitDestination(destinationSetter);
        this.skipMapping(this.collector.collect());
        this.collector.reset();
    }

    private void skipMapping(MappingImpl skipMapping) {
        String prefix = skipMapping.getPath();
        List<String> conflictPaths = this.typeMap.getMappings().stream().map(Mapping::getPath).filter(path -> path.startsWith(prefix) && !path.equals(prefix)).collect(Collectors.toList());
        if (conflictPaths.isEmpty()) {
            this.typeMap.addMapping(skipMapping);
        } else {
            this.collector.getErrors().skipConflict(skipMapping.getPath(), conflictPaths);
            this.collector.getErrors().throwConfigurationExceptionIfErrorsExist();
        }
    }

    @Override
    public <V> void skip(SourceGetter<S> sourceGetter, DestinationSetter<D, V> destinationSetter) {
        this.options.skipType = 1;
        this.visitSource(sourceGetter);
        this.visitDestination(destinationSetter);
        this.skipMapping(this.collector.collect());
        this.collector.reset();
    }

    private void visitSource(SourceGetter<S> sourceGetter) {
        Assert.notNull(sourceGetter, "sourceGetter");
        try {
            Object sourceProperty = sourceGetter.get(this.source);
            if (this.source == sourceProperty) {
                this.collector.mapFromSource(this.typeMap.getSourceType());
            }
            if (this.collector.isNoSourceGetter()) {
                this.collector.mapFromConstant(sourceProperty);
            }
        }
        catch (NullPointerException e) {
            if (this.collector.getProxyErrors().hasErrors()) {
                throw this.collector.getProxyErrors().toException();
            }
            throw e;
        }
        catch (ErrorsException e) {
            throw e.getErrors().toConfigurationException();
        }
    }

    private <V> void visitDestination(DestinationSetter<D, V> destinationSetter) {
        Assert.notNull(destinationSetter, "destinationSetter");
        try {
            destinationSetter.accept(this.destination, this.destinationValue(destinationSetter));
        }
        catch (NullPointerException e) {
            if (this.collector.getProxyErrors().hasErrors()) {
                throw this.collector.getProxyErrors().toException();
            }
            throw e;
        }
        catch (ErrorsException e) {
            throw e.getErrors().toConfigurationException();
        }
    }

    private <V> V destinationValue(DestinationSetter<D, V> destinationSetter) {
        Class<?> valueClass;
        Class<?>[] typeArguments = TypeResolver.resolveRawArguments(DestinationSetter.class, destinationSetter.getClass());
        if (typeArguments != null && Primitives.isPrimitive(valueClass = typeArguments[1])) {
            return (V)Primitives.defaultValue(Primitives.primitiveFor(valueClass));
        }
        return null;
    }
}

