/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class CharacterConverter
implements ConditionalConverter<Object, Character> {
    CharacterConverter() {
    }

    @Override
    public Character convert(MappingContext<Object, Character> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        String stringValue = source.toString();
        if (stringValue.length() == 0) {
            return null;
        }
        return Character.valueOf(stringValue.charAt(0));
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        boolean destMatch;
        boolean bl = destMatch = destinationType == Character.class || destinationType == Character.TYPE;
        return destMatch ? (sourceType == Character.class || sourceType == Character.TYPE ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.PARTIAL) : ConditionalConverter.MatchResult.NONE;
    }
}

