/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.EventFactory;
import com.topologi.diffx.event.impl.ProcessingInstructionEvent;
import com.topologi.diffx.load.AttributeComparator;
import com.topologi.diffx.load.LoadingException;
import com.topologi.diffx.load.XMLRecorder;
import com.topologi.diffx.load.text.TextTokenizer;
import com.topologi.diffx.load.text.TokenizerFactory;
import com.topologi.diffx.sequence.EventSequence;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SAXRecorder
implements XMLRecorder {
    private static XMLReader reader;
    private static final String DEFAULT_XML_READER;
    private static String readerClassName;
    private static boolean newReader;
    private DiffXConfig config = new DiffXConfig();
    protected transient EventSequence sequence;

    @Override
    public EventSequence process(File file) throws LoadingException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        EventSequence seq = null;
        seq = this.process(new InputSource(in));
        ((InputStream)in).close();
        in = null;
        return seq;
    }

    @Override
    public EventSequence process(String xml) throws LoadingException, IOException {
        return this.process(new InputSource(new StringReader(xml)));
    }

    @Override
    public EventSequence process(InputSource is) throws LoadingException, IOException {
        if (reader == null || newReader) {
            SAXRecorder.init();
        }
        reader.setContentHandler(new RecorderHandler());
        reader.setErrorHandler(new RecorderErrorHandler());
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", this.config.isNamespaceAware());
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.config.isReportPrefixDifferences());
            reader.parse(is);
        }
        catch (SAXException ex) {
            throw new LoadingException(ex);
        }
        return this.sequence;
    }

    public DiffXConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    public static String getXMLReaderClass() {
        return readerClassName;
    }

    public static void setXMLReaderClass(String className) {
        if (className == null) {
            className = DEFAULT_XML_READER;
        }
        newReader = !className.equals(readerClassName);
        readerClassName = className;
    }

    private static void init() throws LoadingException {
        try {
            reader = XMLReaderFactory.createXMLReader(readerClassName);
            reader.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXException ex) {
            throw new LoadingException(ex);
        }
    }

    static {
        String className;
        try {
            className = XMLReaderFactory.createXMLReader().getClass().getName();
        }
        catch (SAXException ex) {
            className = "";
        }
        readerClassName = DEFAULT_XML_READER = className;
        newReader = true;
    }

    private static final class RecorderErrorHandler
    implements ErrorHandler {
        private RecorderErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }

    private final class RecorderHandler
    extends DefaultHandler {
        private final StringBuffer ch = new StringBuffer();
        private final AttributeComparator comparator = new AttributeComparator();
        private transient int currentWeight = -1;
        private transient List<OpenElementEvent> openElements = new ArrayList<OpenElementEvent>();
        private transient List<Integer> weights = new ArrayList<Integer>();
        private transient EventFactory efactory;
        private transient TextTokenizer tokenizer;

        private RecorderHandler() {
        }

        @Override
        public void startDocument() {
            SAXRecorder.this.sequence = new EventSequence();
            this.efactory = new EventFactory(SAXRecorder.this.config.isNamespaceAware());
            this.tokenizer = TokenizerFactory.get(SAXRecorder.this.config);
            SAXRecorder.this.sequence.mapPrefix("http://www.w3.org/XML/1998/namespace", "xml");
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            SAXRecorder.this.sequence.mapPrefix(uri, prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.recordCharacters();
            if (this.currentWeight > 0) {
                this.weights.add(new Integer(this.currentWeight));
            }
            this.currentWeight = 1;
            OpenElementEvent open = this.efactory.makeOpenElement(uri, localName, qName);
            this.openElements.add(open);
            SAXRecorder.this.sequence.addEvent(open);
            this.handleAttributes(atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.recordCharacters();
            OpenElementEvent open = this.popLastOpenElement();
            open.setWeight(this.currentWeight);
            CloseElementEvent close = this.efactory.makeCloseElement(open);
            close.setWeight(this.currentWeight);
            SAXRecorder.this.sequence.addEvent(close);
            this.currentWeight += this.popWeight();
        }

        @Override
        public void characters(char[] buf, int pos, int len) {
            this.ch.append(buf, pos, len);
        }

        @Override
        public void ignorableWhitespace(char[] buf1, int pos, int len) {
        }

        @Override
        public void processingInstruction(String target, String data) {
            SAXRecorder.this.sequence.addEvent(new ProcessingInstructionEvent(target, data));
            ++this.currentWeight;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        private void recordCharacters() {
            if (this.ch != null) {
                List<TextEvent> events = this.tokenizer.tokenize(this.ch);
                for (TextEvent e : events) {
                    SAXRecorder.this.sequence.addEvent(e);
                }
                this.currentWeight += events.size();
                this.ch.setLength(0);
            }
        }

        private OpenElementEvent popLastOpenElement() {
            return this.openElements.remove(this.openElements.size() - 1);
        }

        private int popWeight() {
            if (this.weights.size() > 0) {
                return this.weights.remove(this.weights.size() - 1);
            }
            return 0;
        }

        private void handleAttributes(Attributes atts) {
            if (atts.getLength() == 1) {
                SAXRecorder.this.sequence.addEvent(this.efactory.makeAttribute(atts.getURI(0), atts.getLocalName(0), atts.getQName(0), atts.getValue(0)));
            } else if (atts.getLength() > 1) {
                AttributeEvent[] attEvents = new AttributeEvent[atts.getLength()];
                for (int i = 0; i < atts.getLength(); ++i) {
                    attEvents[i] = this.efactory.makeAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
                    attEvents[i].setWeight(2);
                    this.currentWeight += 2;
                }
                Arrays.sort(attEvents, this.comparator);
                for (AttributeEvent attEvent : attEvents) {
                    SAXRecorder.this.sequence.addEvent(attEvent);
                }
            }
        }
    }
}

