/*
 * Decompiled with CFR 0.152.
 */
package org.xlsx4j.model;

import java.util.Date;
import org.docx4j.openpackaging.parts.SpreadsheetML.Styles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xlsx4j.org.apache.poi.ss.usermodel.BuiltinFormats;
import org.xlsx4j.org.apache.poi.ss.usermodel.DateUtil;
import org.xlsx4j.sml.CTCellStyle;
import org.xlsx4j.sml.CTXf;
import org.xlsx4j.sml.Cell;

public class CellUtils {
    protected static Logger log = LoggerFactory.getLogger(CellUtils.class);
    public static final int CELL_TYPE_NUMERIC = 0;
    public static final int CELL_TYPE_STRING = 1;
    public static final int CELL_TYPE_FORMULA = 2;
    public static final int CELL_TYPE_BLANK = 3;
    public static final int CELL_TYPE_BOOLEAN = 4;
    public static final int CELL_TYPE_ERROR = 5;
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";

    protected CellUtils() {
    }

    public static double getNumericCellValue(Cell _cell) {
        log.debug("In getNumericCellValue " + _cell.getV());
        int cellType = CellUtils.getCellType(_cell);
        switch (cellType) {
            case 3: {
                return 0.0;
            }
            case 0: 
            case 2: {
                if (_cell.getV() != null) {
                    String v = _cell.getV();
                    if (v.isEmpty()) {
                        return 0.0;
                    }
                    try {
                        return Double.parseDouble(v);
                    }
                    catch (NumberFormatException e) {
                        throw CellUtils.typeMismatch(0, 1, false);
                    }
                }
                return 0.0;
            }
        }
        throw CellUtils.typeMismatch(0, cellType, false);
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    public static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + CellUtils.getCellTypeName(expectedTypeCode) + " value from a " + CellUtils.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    public static int getCellType(Cell _cell) {
        if (_cell.getF() != null) {
            return 2;
        }
        int cellTypeCode = CellUtils.getBaseCellType(_cell, true);
        log.debug(CellUtils.getCellTypeName(cellTypeCode));
        return cellTypeCode;
    }

    private static int getBaseCellType(Cell _cell, boolean blankCells) {
        switch (_cell.getT()) {
            case B: {
                return 4;
            }
            case N: {
                if (_cell.getV() == null && blankCells) {
                    return 3;
                }
                return 0;
            }
            case E: {
                return 5;
            }
            case S: 
            case INLINE_STR: 
            case STR: {
                return 1;
            }
        }
        throw new IllegalStateException("Illegal cell type: " + (Object)((Object)_cell.getT()));
    }

    public static CTCellStyle getCellStyle(Cell _cell) {
        Styles stylesPart = _cell.getWorksheetPart().getWorkbookPart().getStylesPart();
        CTXf xf = stylesPart.getXfByIndex(_cell.getS());
        if (xf == null) {
            throw new RuntimeException("xf unexpectedly null");
        }
        return stylesPart.getStyleByIndex(xf.getXfId());
    }

    public static long getNumberFormatIndex(Cell _cell) {
        Styles stylesPart = _cell.getWorksheetPart().getWorkbookPart().getStylesPart();
        CTXf xf = stylesPart.getXfByIndex(_cell.getS());
        if (xf == null) {
            throw new RuntimeException("xf unexpectedly null");
        }
        log.debug("Using NumFmtId " + xf.getNumFmtId());
        return xf.getNumFmtId();
    }

    public static String getNumberFormatString(Cell _cell) {
        long idx = CellUtils.getNumberFormatIndex(_cell);
        return CellUtils.getFormat((int)idx);
    }

    private static String getFormat(int index) {
        String fmt = null;
        if (fmt == null) {
            fmt = BuiltinFormats.getBuiltinFormat(index);
        }
        log.debug("Using BuiltinFormat " + fmt);
        return fmt;
    }

    public static Date getDateCellValue(Cell _cell) {
        boolean date1904 = _cell.getWorksheetPart().getWorkbookPart().isDate1904();
        int cellType = CellUtils.getCellType(_cell);
        if (cellType == 3) {
            return null;
        }
        double value = CellUtils.getNumericCellValue(_cell);
        return DateUtil.getJavaDate(value, date1904);
    }

    public static boolean getBooleanCellValue(Cell _cell) {
        int cellType = CellUtils.getCellType(_cell);
        switch (cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return _cell.getV() != null && TRUE_AS_STRING.equals(_cell.getV());
            }
            case 2: {
                return _cell.getV() != null && TRUE_AS_STRING.equals(_cell.getV());
            }
        }
        throw CellUtils.typeMismatch(4, cellType, false);
    }
}

