/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class OrderObject
extends SqlObject {
    private final Dir _dir;
    private final SqlObject _obj;
    private NullOrder _nullOrder;

    public OrderObject(Dir dir, Object obj) {
        this(dir, Converter.toCustomColumnSqlObject(obj));
    }

    public OrderObject(Dir dir, SqlObject obj) {
        this._dir = dir;
        this._obj = obj;
    }

    public OrderObject setNullOrder(NullOrder nullOrder) {
        this._nullOrder = nullOrder;
        return this;
    }

    SqlObject getObject() {
        return this._obj;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        this._obj.collectSchemaObjects(vContext);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        app.append(this._obj).append((Object)this._dir);
        if (this._nullOrder != null) {
            app.append(" NULLS").append((Object)this._nullOrder);
        }
    }

    public static enum NullOrder {
        FIRST(" FIRST"),
        LAST(" LAST");

        private final String _dirStr;

        private NullOrder(String dirStr) {
            this._dirStr = dirStr;
        }

        public String toString() {
            return this._dirStr;
        }
    }

    public static enum Dir {
        ASCENDING(" ASC"),
        DESCENDING(" DESC");

        private final String _dirStr;

        private Dir(String dirStr) {
            this._dirStr = dirStr;
        }

        public String toString() {
            return this._dirStr;
        }
    }
}

