/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class QueryPreparer {
    public static final int DEFAULT_START_INDEX = 1;
    private static final int NO_INDEX = -1;
    private int _curIndex;
    private List<StaticPlaceHolder> _staticPlaceHolders;

    public QueryPreparer() {
        this(1);
    }

    public QueryPreparer(int startIndex) {
        if (startIndex < 1) {
            throw new IllegalArgumentException("invalid start index");
        }
        this._curIndex = startIndex;
    }

    public PlaceHolder getNewPlaceHolder() {
        return new PlaceHolder(this);
    }

    public MultiPlaceHolder getNewMultiPlaceHolder() {
        return new MultiPlaceHolder(this);
    }

    public ListPlaceHolder getNewListPlaceHolder() {
        return new ListPlaceHolder(this);
    }

    public StaticPlaceHolder addStaticPlaceHolder(String val) {
        return this.addStaticPlaceHolder(new StringStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Long val) {
        if (val != null) {
            return this.addStaticPlaceHolder(new LongStaticPlaceHolder(val, this));
        }
        return this.addStaticPlaceHolder(new NullStaticPlaceHolder(-5, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Integer val) {
        if (val != null) {
            return this.addStaticPlaceHolder(new IntegerStaticPlaceHolder(val, this));
        }
        return this.addStaticPlaceHolder(new NullStaticPlaceHolder(4, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Boolean val) {
        if (val != null) {
            return this.addStaticPlaceHolder(new BooleanStaticPlaceHolder(val, this));
        }
        return this.addStaticPlaceHolder(new NullStaticPlaceHolder(16, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(long val) {
        return this.addStaticPlaceHolder(new LongStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(int val) {
        return this.addStaticPlaceHolder(new IntegerStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(boolean val) {
        return this.addStaticPlaceHolder(new BooleanStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Object obj) {
        return this.addStaticPlaceHolder(new ObjectStaticPlaceHolder<Object>(obj, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Object obj, int sqlType) {
        return this.addStaticPlaceHolder(new TypedStaticPlaceHolder(obj, sqlType, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(StaticPlaceHolder ph) {
        if (this._staticPlaceHolders == null) {
            this._staticPlaceHolders = new ArrayList<StaticPlaceHolder>();
        }
        this._staticPlaceHolders.add(ph);
        return ph;
    }

    public void setStaticValues(PreparedStatement ps) throws SQLException {
        if (this._staticPlaceHolders != null) {
            for (StaticPlaceHolder ph : this._staticPlaceHolders) {
                ph.setValue(ps);
            }
        }
    }

    public String toString() {
        Formatter fmt = new Formatter();
        if (this._staticPlaceHolders != null) {
            for (StaticPlaceHolder placeHolder : this._staticPlaceHolders) {
                if (placeHolder != null) {
                    fmt.format("[%s] %s%n", placeHolder.getClass().getSimpleName(), placeHolder.displayToString());
                    continue;
                }
                fmt.format("<null>???", new Object[0]);
            }
        } else {
            fmt.format("<No static place holders>%n", new Object[0]);
        }
        return fmt.toString();
    }

    public static class BooleanStaticPlaceHolder
    extends StaticPlaceHolder {
        private boolean _val;

        public BooleanStaticPlaceHolder(boolean val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setBoolean(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class IntegerStaticPlaceHolder
    extends StaticPlaceHolder {
        private int _val;

        public IntegerStaticPlaceHolder(int val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setInt(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class LongStaticPlaceHolder
    extends StaticPlaceHolder {
        private long _val;

        public LongStaticPlaceHolder(long val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setLong(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class StringStaticPlaceHolder
    extends ObjectStaticPlaceHolder<String> {
        public StringStaticPlaceHolder(String val, QueryPreparer outer) {
            super(val, outer);
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setString((String)this._val, ps);
        }
    }

    public static class TypedStaticPlaceHolder
    extends ObjectStaticPlaceHolder<Object> {
        private int _sqlType;

        public TypedStaticPlaceHolder(Object val, int sqlType, QueryPreparer outer) {
            super(val, outer);
            this._sqlType = sqlType;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setObject(this._val, this._sqlType, ps);
        }
    }

    public static class ObjectStaticPlaceHolder<ObjType>
    extends StaticPlaceHolder {
        protected ObjType _val;

        public ObjectStaticPlaceHolder(ObjType val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setObject(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class NullStaticPlaceHolder
    extends StaticPlaceHolder {
        private int _sqlType;

        public NullStaticPlaceHolder(int sqlType, QueryPreparer outer) {
            super(outer);
            this._sqlType = sqlType;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setNull(this._sqlType, ps);
        }

        @Override
        public String displayToString() {
            return "NullSqlType=" + this._sqlType;
        }
    }

    public static class ListPlaceHolder
    extends PlaceHolder {
        private final SqlObjectList<PlaceHolder> _delegates = SqlObjectList.create();

        public ListPlaceHolder(QueryPreparer outer) {
            super(outer);
        }

        @Override
        public boolean isInQuery() {
            return !this._delegates.isEmpty() && this._delegates.get(0).isInQuery();
        }

        @Override
        public int getIndex() {
            if (this._delegates.size() <= 1) {
                return !this._delegates.isEmpty() ? this._delegates.get(0).getIndex() : -1;
            }
            throw new UnsupportedOperationException("This method may not be used for multi-value ListPlaceHolder");
        }

        @Override
        public List<Integer> getIndexes() {
            ArrayList<Integer> idxs = new ArrayList<Integer>(this._delegates.size());
            for (PlaceHolder ph : this._delegates) {
                idxs.addAll(ph.getIndexes());
            }
            return idxs;
        }

        public PlaceHolder addNewPlaceHolder() {
            return this.addPlaceHolder(this.getOuter().getNewPlaceHolder());
        }

        public MultiPlaceHolder addNewMultiPlaceHolder() {
            return this.addPlaceHolder(this.getOuter().getNewMultiPlaceHolder());
        }

        public StaticPlaceHolder addStaticPlaceHolder(StaticPlaceHolder ph) {
            return this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(ph));
        }

        public ListPlaceHolder addPlaceHolders(int size) {
            for (int i = 0; i < size; ++i) {
                this.addPlaceHolder(this.getOuter().getNewPlaceHolder());
            }
            return this;
        }

        private <P extends PlaceHolder> P addPlaceHolder(P ph) {
            this._delegates.addObject(ph);
            return ph;
        }

        public ListPlaceHolder addStaticStrings(String ... values) {
            return this.addStaticStrings(values != null ? Arrays.asList(values) : Collections.emptyList());
        }

        public ListPlaceHolder addStaticStrings(Iterable<? extends String> values) {
            if (values != null) {
                for (String string : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(string));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticLongs(long ... values) {
            if (values != null) {
                for (long value : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(value));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticLongs(Iterable<? extends Long> values) {
            if (values != null) {
                for (Long l : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(l));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticIntegers(int ... values) {
            if (values != null) {
                for (int value : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(value));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticIntegers(Iterable<? extends Integer> values) {
            if (values != null) {
                for (Integer n : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(n));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticBooleans(boolean ... values) {
            if (values != null) {
                for (boolean value : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(value));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticBooleans(Iterable<? extends Boolean> values) {
            if (values != null) {
                for (Boolean bl : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(bl));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticObjects(Object ... values) {
            return this.addStaticObjects(values != null ? Arrays.asList(values) : Collections.emptyList());
        }

        public ListPlaceHolder addStaticObjects(Iterable<?> values) {
            if (values != null) {
                for (Object value : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(value));
                }
            }
            return this;
        }

        public ListPlaceHolder addStaticObjects(int sqlType, Object ... values) {
            return this.addStaticObjects(sqlType, values != null ? Arrays.asList(values) : Collections.emptyList());
        }

        public ListPlaceHolder addStaticObjects(int sqlType, Iterable<?> values) {
            if (values != null) {
                for (Object value : values) {
                    this.addPlaceHolder(this.getOuter().addStaticPlaceHolder(value, sqlType));
                }
            }
            return this;
        }

        public void setNulls(int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (PlaceHolder ph : this._delegates) {
                    ph.setNull(sqlType, ps);
                }
            }
        }

        public void setInts(PreparedStatement ps, int ... values) throws SQLException {
            if (this.isInQuery()) {
                int idx = 0;
                for (PlaceHolder ph : this._delegates) {
                    ph.setInt(values[idx++], ps);
                }
            }
        }

        public void setInts(PreparedStatement ps, Iterable<? extends Integer> values) throws SQLException {
            if (this.isInQuery()) {
                Iterator<? extends Integer> iter = values.iterator();
                for (PlaceHolder ph : this._delegates) {
                    ph.setInt(iter.next(), ps);
                }
            }
        }

        public void setLongs(PreparedStatement ps, long ... values) throws SQLException {
            if (this.isInQuery()) {
                int idx = 0;
                for (PlaceHolder ph : this._delegates) {
                    ph.setLong(values[idx++], ps);
                }
            }
        }

        public void setLongs(PreparedStatement ps, Iterable<? extends Long> values) throws SQLException {
            if (this.isInQuery()) {
                Iterator<? extends Long> iter = values.iterator();
                for (PlaceHolder ph : this._delegates) {
                    ph.setLong(iter.next(), ps);
                }
            }
        }

        public void setBooleans(PreparedStatement ps, boolean ... values) throws SQLException {
            if (this.isInQuery()) {
                int idx = 0;
                for (PlaceHolder ph : this._delegates) {
                    ph.setBoolean(values[idx++], ps);
                }
            }
        }

        public void setBooleans(PreparedStatement ps, Iterable<? extends Boolean> values) throws SQLException {
            if (this.isInQuery()) {
                Iterator<? extends Boolean> iter = values.iterator();
                for (PlaceHolder ph : this._delegates) {
                    ph.setBoolean(iter.next(), ps);
                }
            }
        }

        public void setStrings(PreparedStatement ps, String ... values) throws SQLException {
            if (this.isInQuery()) {
                this.setStringsImpl(ps, Arrays.asList(values));
            }
        }

        public void setStrings(PreparedStatement ps, Iterable<? extends String> values) throws SQLException {
            if (this.isInQuery()) {
                this.setStringsImpl(ps, values);
            }
        }

        private void setStringsImpl(PreparedStatement ps, Iterable<? extends String> values) throws SQLException {
            Iterator<? extends String> iter = values.iterator();
            for (PlaceHolder ph : this._delegates) {
                ph.setString(iter.next(), ps);
            }
        }

        public void setObjects(PreparedStatement ps, Object ... values) throws SQLException {
            if (this.isInQuery()) {
                this.setObjectsImpl(ps, Arrays.asList(values));
            }
        }

        public void setObjects(PreparedStatement ps, Iterable<?> values) throws SQLException {
            if (this.isInQuery()) {
                this.setObjectsImpl(ps, values);
            }
        }

        private void setObjectsImpl(PreparedStatement ps, Iterable<?> values) throws SQLException {
            Iterator<?> iter = values.iterator();
            for (PlaceHolder ph : this._delegates) {
                ph.setObject(iter.next(), ps);
            }
        }

        public void setObjects(int sqlType, PreparedStatement ps, Object ... values) throws SQLException {
            if (this.isInQuery()) {
                this.setObjectsImpl(sqlType, ps, Arrays.asList(values));
            }
        }

        public void setObjects(int sqlType, PreparedStatement ps, Iterable<?> values) throws SQLException {
            if (this.isInQuery()) {
                this.setObjectsImpl(sqlType, ps, values);
            }
        }

        private void setObjectsImpl(int sqlType, PreparedStatement ps, Iterable<?> values) throws SQLException {
            Iterator<?> iter = values.iterator();
            for (PlaceHolder ph : this._delegates) {
                ph.setObject(iter.next(), sqlType, ps);
            }
        }

        @Override
        public final void appendTo(AppendableExt app) throws IOException {
            this._delegates.appendTo(app);
        }
    }

    public static abstract class StaticPlaceHolder
    extends PlaceHolder {
        public StaticPlaceHolder(QueryPreparer outer) {
            super(outer);
        }

        public abstract void setValue(PreparedStatement var1) throws SQLException;

        public abstract String displayToString();
    }

    public static class MultiPlaceHolder
    extends PlaceHolder {
        private List<Integer> _indexes = new LinkedList<Integer>();

        public MultiPlaceHolder(QueryPreparer outer) {
            super(outer);
        }

        @Override
        public List<Integer> getIndexes() {
            return this._indexes;
        }

        @Override
        public boolean isInQuery() {
            return !this.getIndexes().isEmpty();
        }

        @Override
        protected void addIndex(int index) {
            this.getIndexes().add(index);
        }

        @Override
        public int getIndex() {
            if (this.getIndexes().size() <= 1) {
                return !this.getIndexes().isEmpty() ? this.getIndexes().get(0) : -1;
            }
            throw new UnsupportedOperationException("This method may not be used for multi-use MultiPlaceHolder");
        }

        @Override
        public void setNull(int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setNull(index, sqlType);
                }
            }
        }

        @Override
        public void setInt(int value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setInt(index, value);
                }
            }
        }

        @Override
        public void setLong(long value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setLong(index, value);
                }
            }
        }

        @Override
        public void setBoolean(boolean value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setBoolean(index, value);
                }
            }
        }

        @Override
        protected void setNonNullString(String value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setString(index, value);
                }
            }
        }

        @Override
        public void setObject(Object value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setObject(index, value);
                }
            }
        }

        @Override
        protected void setNonNullObject(Object value, int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setObject((int)index, value, sqlType);
                }
            }
        }
    }

    public static class PlaceHolder
    extends SqlObject {
        private QueryPreparer _outer;
        private int _index = -1;

        public PlaceHolder(QueryPreparer outer) {
            this._outer = outer;
        }

        protected QueryPreparer getOuter() {
            return this._outer;
        }

        public boolean isInQuery() {
            return this.getIndex() != -1;
        }

        private void setIndex(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }

        public List<Integer> getIndexes() {
            return Collections.singletonList(this._index);
        }

        protected void addIndex(int index) {
            if (this.getIndex() != -1) {
                throw new IllegalStateException("attempt to reset value of PlaceHolder, cannot reuse or use multiple times in the same query");
            }
            this.setIndex(index);
        }

        public void setNull(int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setNull(this.getIndex(), sqlType);
            }
        }

        public void setInt(int value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setInt(this.getIndex(), value);
            }
        }

        public void setInt(Integer value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setInt((int)value, ps);
            } else {
                this.setNull(4, ps);
            }
        }

        public void setLong(long value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setLong(this.getIndex(), value);
            }
        }

        public void setLong(Long value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setLong((long)value, ps);
            } else {
                this.setNull(-5, ps);
            }
        }

        public void setBoolean(boolean value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setBoolean(this.getIndex(), value);
            }
        }

        public void setBoolean(Boolean value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setBoolean((boolean)value, ps);
            } else {
                this.setNull(16, ps);
            }
        }

        protected void setNonNullString(String value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setString(this.getIndex(), value);
            }
        }

        public void setString(String value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setNonNullString(value, ps);
            } else {
                this.setNull(12, ps);
            }
        }

        public void setObject(Object value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setObject(this.getIndex(), value);
            }
        }

        protected void setNonNullObject(Object value, int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setObject(this.getIndex(), value, sqlType);
            }
        }

        public void setObject(Object value, int sqlType, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setNonNullObject(value, sqlType, ps);
            } else {
                this.setNull(sqlType, ps);
            }
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            this.addIndex(this._outer._curIndex++);
            SqlObject.QUESTION_MARK.appendTo(app);
        }
    }
}

