/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class WindowDefinitionClause
extends SqlObject {
    private final SqlObjectList<SqlObject> _columns = SqlObjectList.create();
    private final SqlObjectList<SqlObject> _ordering = SqlObjectList.create();
    private Object _frameUnits;
    private SqlObject _frameStart;
    private SqlObject _frameEnd;
    private Object _frameExclusion;

    public WindowDefinitionClause addPartitionColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public WindowDefinitionClause addOrdering(Object columnStr, OrderObject.Dir dir) {
        return this.addOrderings(new OrderObject(dir, Converter.toCustomColumnSqlObject(columnStr)));
    }

    public WindowDefinitionClause addOrderings(Object ... columnStrs) {
        this._ordering.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public WindowDefinitionClause setFrame(Object frameUnits, Object frameStart) {
        return this.setFrame(frameUnits, frameStart, null);
    }

    public WindowDefinitionClause setFrame(Object frameUnits, Object frameStart, Object frameExclusion) {
        return this.setFrameImpl(frameUnits, frameStart, null, frameExclusion);
    }

    public WindowDefinitionClause setFrameBetween(Object frameUnits, Object frameStart, Object frameEnd) {
        return this.setFrameBetween(frameUnits, frameStart, frameEnd, null);
    }

    public WindowDefinitionClause setFrameBetween(Object frameUnits, Object frameStart, Object frameEnd, Object frameExclusion) {
        return this.setFrameImpl(frameUnits, frameStart, frameEnd, frameExclusion);
    }

    private WindowDefinitionClause setFrameImpl(Object frameUnits, Object frameStart, Object frameEnd, Object frameExclusion) {
        this._frameUnits = frameUnits;
        this._frameStart = Converter.toCustomSqlObject(frameStart);
        if (frameEnd != null) {
            this._frameEnd = Converter.toCustomSqlObject(frameEnd);
        }
        this._frameExclusion = frameExclusion;
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        this._columns.collectSchemaObjects(vContext);
        this._ordering.collectSchemaObjects(vContext);
        WindowDefinitionClause.collectSchemaObjects(this._frameStart, vContext);
        WindowDefinitionClause.collectSchemaObjects(this._frameEnd, vContext);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        app.append("(");
        boolean hasPreceding = false;
        if (!this._columns.isEmpty()) {
            app.append("PARTITION BY ").append(this._columns);
            hasPreceding = true;
        }
        if (!this._ordering.isEmpty()) {
            if (hasPreceding) {
                app.append(" ");
            }
            app.append("ORDER BY ").append(this._ordering);
            hasPreceding = true;
        }
        if (this._frameUnits != null && this._frameStart != null) {
            if (hasPreceding) {
                app.append(" ");
            }
            app.append(this._frameUnits).append(" ");
            if (this._frameEnd == null) {
                app.append(this._frameStart);
            } else {
                app.append("BETWEEN ").append(this._frameStart).append(" AND ").append(this._frameEnd);
            }
            if (this._frameExclusion != null) {
                app.append(" EXCLUDE ").append(this._frameExclusion);
            }
        }
        app.append(")");
    }

    public static class FrameBound
    extends SqlObject {
        public static final FrameBound UNBOUNDED_PRECEDING = new FrameBound("UNBOUNDED", "PRECEDING");
        public static final FrameBound UNBOUNDED_FOLLOWING = new FrameBound("UNBOUNDED", "FOLLOWING");
        public static final FrameBound CURRENT_ROW = new FrameBound(null, "CURRENT ROW");
        private final Object _value;
        private final Object _scope;

        public FrameBound(Object value, Object scope) {
            this._value = value;
            this._scope = scope;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            if (this._value != null) {
                app.append(this._value).append(" ");
            }
            app.append(this._scope);
        }

        public static FrameBound boundedPreceding(int value) {
            return new FrameBound(value, "PRECEDING");
        }

        public static FrameBound boundedFollowing(int value) {
            return new FrameBound(value, "FOLLOWING");
        }
    }

    public static enum FrameExclusion {
        CURRENT_ROW("CURRENT ROW"),
        GROUP("GROUP"),
        TIES("TIES"),
        NO_OTHERS("NO OTHERS");

        private final String _str;

        private FrameExclusion(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }
    }

    public static enum FrameUnits {
        ROWS,
        RANGE;

    }
}

