/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.ExportExecutorWrapper;
import org.qubership.atp.ei.node.config.ExportImportNodeConfig;
import org.qubership.atp.ei.node.dto.ExportNodeInfo;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ExportImportFilesService;
import org.qubership.atp.ei.node.services.ExportNodeService;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.MetricsExportImportService;
import org.qubership.atp.ei.node.services.impl.NotifyService;
import org.qubership.atp.ei.node.services.impl.TasksService;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ExportNodeServiceImpl
implements ExportNodeService {
    private static final Logger log = LoggerFactory.getLogger(ExportNodeServiceImpl.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    private final NotifyService notifyService;
    private final ObjectMapper objectMapper;
    private final ExportExecutor exportExecutor;
    private final TasksService tasksService;
    private final ExportImportFilesService exportImportFilesService;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final FileService fileService;
    private Map<String, String> mdcContext;
    private final MetricsExportImportService metricsExportImportService;

    @Autowired
    public ExportNodeServiceImpl(@Qualifier(value="atpExportThreadExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, NotifyService notifyService, ObjectMapper objectMapper, ExportExecutor exportExecutor, TasksService tasksService, ExportImportFilesService exportImportFilesService, FileService fileService, MetricsExportImportService metricsExportImportService) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.notifyService = notifyService;
        this.objectMapper = objectMapper;
        this.exportExecutor = exportExecutor;
        this.tasksService = tasksService;
        this.exportImportFilesService = exportImportFilesService;
        this.fileService = fileService;
        this.mdcContext = MDC.getCopyOfContextMap();
        this.metricsExportImportService = metricsExportImportService;
    }

    @Override
    public void runExport(RunNodeRequest request) {
        log.info("Income  request {}", (Object)request.toString());
        if (request.getProjectId() == null || request.getTaskId() == null || request.getProcessId() == null) {
            log.error("The the following params should be filled for export to proceed: projectId, taskId, processIdReceived projectId {}. taskId {}, processId {}", new Object[]{request.getProjectId(), request.getTaskId(), request.getProcessId()});
            return;
        }
        this.runExport(request, this.exportExecutor);
    }

    private void runExport(RunNodeRequest request, ExportExecutor exportExecutor) {
        try {
            ExportExecutorWrapper executor = new ExportExecutorWrapper(request, this.fileService.getFolderPath(request.getProjectId(), request.getProcessId(), "export"), exportExecutor, this.getExportNodeInfo(false), this.notifyService, this.objectMapper, this.exportImportFilesService, this.fileService, this.metricsExportImportService);
            this.tasksService.submitTask(request.getTaskId(), executor, this.threadPoolTaskExecutor);
        }
        catch (Exception e) {
            String msg = "Error while start export";
            log.error(msg, (Throwable)e);
            ExportException.throwException(msg, e);
        }
    }

    @Override
    public void cancelExport(UUID projectId, String taskId, String processId) {
        log.debug("Export wrapper, mdcContext = {}", this.mdcContext);
        MdcUtils.setContextMap(this.mdcContext);
        log.info("Cancel Export request for project {} and task {}", (Object)projectId, (Object)taskId);
        this.tasksService.cancelTask(taskId);
        this.deleteExportFile(projectId, processId);
    }

    @Override
    public void deleteExportFile(UUID projectId, String processId) {
        log.info("Delete Export File request for project {} and process {}", (Object)projectId, (Object)processId);
        this.fileService.deleteFolder(projectId, processId, "export");
    }

    @Override
    public ExportNodeInfo getExportNodeInfo(boolean isDetailed) {
        ExportNodeInfo info = new ExportNodeInfo();
        info.setName(this.applicationName);
        info.setVersion("1");
        info.setExportImplementationClass(this.exportExecutor.getClass().getCanonicalName());
        info.setExportImplementationName(this.exportExecutor.getExportImplementationName());
        if (isDetailed) {
            info.setDefaultWorkDir(ExportImportNodeConfig.DEFAULT_WORK_DIR);
            info.setActiveExportCount(this.threadPoolTaskExecutor.getActiveCount());
        }
        return info;
    }
}

